/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.DateKit;

public class TimeInterval {
    private long time;
    private boolean isNano;

    public TimeInterval() {
        this(false);
    }

    public TimeInterval(boolean isNano) {
        this.isNano = isNano;
        this.start();
    }

    public long start() {
        this.time = DateKit.timestamp(this.isNano);
        return this.time;
    }

    public long intervalRestart() {
        long now = DateKit.timestamp(this.isNano);
        long d = now - this.time;
        this.time = now;
        return d;
    }

    public TimeInterval restart() {
        this.time = DateKit.timestamp(this.isNano);
        return this;
    }

    public long interval() {
        return DateKit.timestamp(this.isNano) - this.time;
    }

    public long intervalMs() {
        return this.isNano ? this.interval() / 1000000L : this.interval();
    }

    public long intervalSecond() {
        return this.intervalMs() / Fields.Time.SECOND.getMillis();
    }

    public long intervalMinute() {
        return this.intervalMs() / Fields.Time.MINUTE.getMillis();
    }

    public long intervalHour() {
        return this.intervalMs() / Fields.Time.HOUR.getMillis();
    }

    public long intervalDay() {
        return this.intervalMs() / Fields.Time.DAY.getMillis();
    }

    public long intervalWeek() {
        return this.intervalMs() / Fields.Time.WEEK.getMillis();
    }
}

