/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.image.element;

import java.awt.Color;
import java.awt.Font;
import org.aoju.bus.core.image.element.AbstractElement;

public class TextElement
extends AbstractElement<TextElement> {
    private String text;
    private Font font;
    private boolean strikeThrough;
    private Color color = new Color(0, 0, 0);
    private boolean autoBreakLine = false;
    private int maxLineWidth = 600;
    private int maxLineCount = 2;
    private int lineHeight = 50;

    public TextElement(String text, Font font, int x, int y) {
        this.text = text;
        this.font = font;
        super.setX(x);
        super.setY(y);
    }

    public TextElement(String text, int fontSize, int x, int y) {
        this.text = text;
        this.font = new Font("\u963f\u91cc\u5df4\u5df4\u666e\u60e0\u4f53", 0, fontSize);
        super.setX(x);
        super.setY(y);
    }

    public TextElement(String text, String fontName, int fontSize, int x, int y) {
        this.text = text;
        this.font = new Font(fontName, 0, fontSize);
        super.setX(x);
        super.setY(y);
    }

    public TextElement setAutoBreakLine(int maxLineWidth, int maxLineCount, int lineHeight) {
        this.autoBreakLine = true;
        this.maxLineWidth = maxLineWidth;
        this.maxLineCount = maxLineCount;
        this.lineHeight = lineHeight;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public TextElement setText(String text) {
        this.text = text;
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public TextElement setFont(Font font) {
        this.font = font;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public TextElement setColor(Color color) {
        this.color = color;
        return this;
    }

    public boolean isStrikeThrough() {
        return this.strikeThrough;
    }

    public TextElement setStrikeThrough(boolean strikeThrough) {
        this.strikeThrough = strikeThrough;
        return this;
    }

    public boolean isAutoBreakLine() {
        return this.autoBreakLine;
    }

    public TextElement setAutoBreakLine(boolean autoBreakLine) {
        this.autoBreakLine = autoBreakLine;
        return this;
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public TextElement setMaxLineWidth(int maxLineWidth) {
        this.maxLineWidth = maxLineWidth;
        return this;
    }

    public int getMaxLineCount() {
        return this.maxLineCount;
    }

    public TextElement setMaxLineCount(int maxLineCount) {
        this.maxLineCount = maxLineCount;
        return this;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public TextElement setLineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextElement)) {
            return false;
        }
        TextElement other = (TextElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        Font this$font = this.getFont();
        Font other$font = other.getFont();
        if (this$font == null ? other$font != null : !((Object)this$font).equals(other$font)) {
            return false;
        }
        if (this.isStrikeThrough() != other.isStrikeThrough()) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
            return false;
        }
        if (this.isAutoBreakLine() != other.isAutoBreakLine()) {
            return false;
        }
        if (this.getMaxLineWidth() != other.getMaxLineWidth()) {
            return false;
        }
        if (this.getMaxLineCount() != other.getMaxLineCount()) {
            return false;
        }
        return this.getLineHeight() == other.getLineHeight();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        Font $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : ((Object)$font).hashCode());
        result = result * 59 + (this.isStrikeThrough() ? 79 : 97);
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        result = result * 59 + (this.isAutoBreakLine() ? 79 : 97);
        result = result * 59 + this.getMaxLineWidth();
        result = result * 59 + this.getMaxLineCount();
        result = result * 59 + this.getLineHeight();
        return result;
    }

    public String toString() {
        return "TextElement(text=" + this.getText() + ", font=" + this.getFont() + ", strikeThrough=" + this.isStrikeThrough() + ", color=" + this.getColor() + ", autoBreakLine=" + this.isAutoBreakLine() + ", maxLineWidth=" + this.getMaxLineWidth() + ", maxLineCount=" + this.getMaxLineCount() + ", lineHeight=" + this.getLineHeight() + ")";
    }
}

