/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.image.painter;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.aoju.bus.core.image.element.AbstractElement;
import org.aoju.bus.core.image.element.ImageElement;
import org.aoju.bus.core.image.painter.Painter;

public class ImagePainter
implements Painter {
    @Override
    public void draw(Graphics2D g, AbstractElement element, int canvasWidth) throws Exception {
        ImageElement imageElement = (ImageElement)element;
        BufferedImage image = imageElement.getImage();
        int width = 0;
        int height = 0;
        switch (imageElement.getZoomMode()) {
            case ORIGIN: {
                width = image.getWidth();
                height = image.getHeight();
                break;
            }
            case WIDTH: {
                width = imageElement.getWidth();
                height = image.getHeight() * width / image.getWidth();
                break;
            }
            case HEIGHT: {
                height = imageElement.getHeight();
                width = image.getWidth() * height / image.getHeight();
                break;
            }
            case OPTIONAL: {
                height = imageElement.getHeight();
                width = imageElement.getWidth();
            }
        }
        if (imageElement.getRoundCorner() != null) {
            image = this.makeRoundCorner(image, width, height, imageElement.getRoundCorner());
        }
        if (imageElement.isCenter()) {
            int centerX = (canvasWidth - width) / 2;
            imageElement.setX(centerX);
        }
        g.setComposite(AlphaComposite.getInstance(10, imageElement.getAlpha()));
        g.drawImage(image, imageElement.getX(), imageElement.getY(), width, height, null);
    }

    private BufferedImage makeRoundCorner(BufferedImage srcImage, int width, int height, int radius) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillRoundRect(0, 0, width, height, radius, radius);
        g.setComposite(AlphaComposite.SrcIn);
        g.drawImage(srcImage, 0, 0, width, height, null);
        g.dispose();
        return image;
    }
}

