/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.streams;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;

public class QueueReader
extends Reader {
    private Reader is;
    private LinkedList<Integer> cache = new LinkedList();
    private int peekindex = 0;
    private boolean end = false;
    private int col = 0;
    private int row = 1;

    public QueueReader(Reader is) {
        this.is = is;
    }

    public String readItem(char ... ends) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            switch (this.peek()) {
                case -1: 
                case 10: 
                case 13: 
                case 32: {
                    return sb.toString();
                }
            }
            char[] cArray = ends;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                if (c.charValue() != this.peek()) continue;
                return sb.toString();
            }
            sb.append((char)this.poll());
        }
    }

    public String readLine() throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int v;
            if ((v = this.peek()) == 13 || v == 10) {
                this.poll();
                v = this.peekNext();
                if (v != 13 && v != 10) break;
                this.poll();
                break;
            }
            sb.append((char)this.poll());
        }
        return sb.toString();
    }

    public int poll() throws IOException {
        this.peekindex = 0;
        int v = -1;
        v = this.cache.size() <= 0 ? this.is.read() : this.cache.poll().intValue();
        if (v == -1) {
            this.end = true;
        }
        if (v == 10) {
            this.col = 0;
            ++this.row;
        } else {
            ++this.col;
        }
        return v;
    }

    public int peek(int index) throws IOException {
        while (this.cache.size() <= index) {
            this.cache.add(this.is.read());
        }
        return this.cache.get(index);
    }

    public int peekNext() throws IOException {
        return this.peek(this.peekindex++);
    }

    public int peek() throws IOException {
        int v;
        this.peekindex = 0;
        if ((v = this.peek(this.peekindex++)) == -1) {
            this.end = true;
        }
        return v;
    }

    @Override
    public long skip(long n) throws IOException {
        int s = this.cache.size();
        if (s > 0) {
            if ((long)s < n) {
                n -= (long)s;
            } else {
                int i = 0;
                while ((long)i < n) {
                    this.cache.poll();
                    ++i;
                }
                return n;
            }
        }
        return super.skip(n) + (long)s;
    }

    public boolean isEnd() {
        return this.end;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            if (this.isEnd()) {
                return -1;
            }
            cbuf[off + i] = (char)this.poll();
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
        this.cache.clear();
    }

    public boolean startWith(String start) throws IOException {
        char[] cs = start.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            if (this.peek(i) == cs[i]) continue;
            return false;
        }
        return true;
    }

    public int getCol() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }
}

