/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlKit {
    private static SAXParserFactory factory;

    public static Document readXML(File file) {
        Assert.notNull(file, "Xml file is null !", new Object[0]);
        if (!file.exists()) {
            throw new InstrumentException("File [{}] not a exist!", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new InstrumentException("[{}] not a file!", file.getAbsolutePath());
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream(file);
            Document document = XmlKit.readXML(in);
            return document;
        }
        finally {
            IoKit.close(in);
        }
    }

    public static Document readXML(String pathOrContent) {
        if (StringKit.startWith((CharSequence)pathOrContent, '<')) {
            return XmlKit.parseXml(pathOrContent);
        }
        return XmlKit.readXML(FileKit.file(pathOrContent));
    }

    public static Document readXML(InputStream inputStream) {
        return XmlKit.readXML(new InputSource(inputStream));
    }

    public static Document readXML(Reader reader) {
        return XmlKit.readXML(new InputSource(reader));
    }

    public static Document readXML(InputSource source) {
        DocumentBuilder builder = XmlKit.builder();
        try {
            return builder.parse(source);
        }
        catch (Exception e) {
            throw new InstrumentException("Parse XML from stream error!");
        }
    }

    public static void readBySax(File file, ContentHandler contentHandler) {
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream(file);
            XmlKit.readBySax(new InputSource(in), contentHandler);
        }
        finally {
            IoKit.close(in);
        }
    }

    public static void readBySax(Reader reader, ContentHandler contentHandler) {
        try {
            XmlKit.readBySax(new InputSource(reader), contentHandler);
        }
        finally {
            IoKit.close(reader);
        }
    }

    public static void readBySax(InputStream source, ContentHandler contentHandler) {
        try {
            XmlKit.readBySax(new InputSource(source), contentHandler);
        }
        finally {
            IoKit.close(source);
        }
    }

    public static void readBySax(InputSource source, ContentHandler contentHandler) {
        if (null == factory) {
            factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
        }
        try {
            SAXParser parse = factory.newSAXParser();
            if (contentHandler instanceof DefaultHandler) {
                parse.parse(source, (DefaultHandler)contentHandler);
                return;
            }
            XMLReader reader = parse.getXMLReader();
            reader.setContentHandler(contentHandler);
            reader.parse(source);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> T readObjectFromXml(File source) {
        return XmlKit.readObjectFromXml(new InputSource(FileKit.getInputStream(source)));
    }

    public static <T> T readObjectFromXml(String xmlStr) {
        return XmlKit.readObjectFromXml(new InputSource(StringKit.getReader(xmlStr)));
    }

    public static <T> T readObjectFromXml(InputSource source) {
        Object result;
        XMLDecoder xmldec = null;
        try {
            xmldec = new XMLDecoder(source);
            result = xmldec.readObject();
        }
        catch (Throwable throwable) {
            IoKit.close(xmldec);
            throw throwable;
        }
        IoKit.close(xmldec);
        return (T)result;
    }

    public static Document parseXml(String xmlStr) {
        if (StringKit.isBlank(xmlStr)) {
            throw new IllegalArgumentException("XML content string is empty !");
        }
        xmlStr = XmlKit.cleanInvalid(xmlStr);
        return XmlKit.readXML(new InputSource(StringKit.getReader(xmlStr)));
    }

    public static String toString(Document doc) {
        return XmlKit.toString(doc, false);
    }

    public static String toString(Document doc, boolean isPretty) {
        return XmlKit.toString(doc, "UTF-8", isPretty);
    }

    public static String toString(Document doc, String charset, boolean isPretty) {
        return XmlKit.toString(doc, charset, isPretty, false);
    }

    public static String toString(Document doc, String charset, boolean isPretty, boolean omitXmlDeclaration) {
        StringWriter writer = StringKit.getWriter();
        try {
            XmlKit.write((Node)doc, writer, charset, isPretty ? 2 : 0, omitXmlDeclaration);
        }
        catch (Exception e) {
            throw new InstrumentException("Trans xml document to string error!");
        }
        return writer.toString();
    }

    public static void toFile(Document doc, String absolutePath) {
        XmlKit.toFile(doc, absolutePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(Document doc, String path, String charset) {
        if (StringKit.isBlank(charset)) {
            charset = doc.getXmlEncoding();
        }
        if (StringKit.isBlank(charset)) {
            charset = "UTF-8";
        }
        BufferedWriter writer = null;
        try {
            writer = FileKit.getWriter(path, charset, false);
            XmlKit.write((Node)doc, writer, charset, 2);
        }
        catch (Throwable throwable) {
            IoKit.close(writer);
            throw throwable;
        }
        IoKit.close(writer);
    }

    public static String format(Document doc) {
        return XmlKit.toString(doc, true);
    }

    public static String format(String xmlStr) {
        return XmlKit.format(XmlKit.parseXml(xmlStr));
    }

    public static void write(Node node, Writer writer, String charset, int indent) {
        XmlKit.transform(new DOMSource(node), new StreamResult(writer), charset, indent);
    }

    public static void write(Node node, Writer writer, String charset, int indent, boolean omitXmlDeclaration) {
        XmlKit.transform(new DOMSource(node), new StreamResult(writer), charset, indent, omitXmlDeclaration);
    }

    public static void write(Node node, OutputStream out, String charset, int indent) {
        XmlKit.transform(new DOMSource(node), new StreamResult(out), charset, indent);
    }

    public static void write(Node node, OutputStream out, String charset, int indent, boolean omitXmlDeclaration) {
        XmlKit.transform(new DOMSource(node), new StreamResult(out), charset, indent, omitXmlDeclaration);
    }

    public static void transform(Source source, Result result, String charset, int indent) {
        XmlKit.transform(source, result, charset, indent, false);
    }

    public static void transform(Source source, Result result, String charset, int indent, boolean omitXmlDeclaration) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer xformer = factory.newTransformer();
            if (indent > 0) {
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
            }
            if (StringKit.isNotBlank(charset)) {
                xformer.setOutputProperty("encoding", charset);
            }
            if (omitXmlDeclaration) {
                xformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            xformer.transform(source, result);
        }
        catch (Exception e) {
            throw new InstrumentException("Trans xml document to string error!");
        }
    }

    public static Document createXml() {
        return XmlKit.builder().newDocument();
    }

    public static Document createXml(String rootElementName) {
        return XmlKit.createXml(rootElementName, null);
    }

    public static Document createXml(String rootElementName, String namespace) {
        Document doc = XmlKit.createXml();
        doc.appendChild(null == namespace ? doc.createElement(rootElementName) : doc.createElementNS(namespace, rootElementName));
        return doc;
    }

    public static Element getElement(Document doc) {
        return null == doc ? null : doc.getDocumentElement();
    }

    public static Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childEle = (Element)nodeList.item(i);
            if (childEle != null && childEle.getParentNode() != element) continue;
            return childEle;
        }
        return null;
    }

    public static String getText(Element element, String tagName) {
        Element child = XmlKit.getElement(element, tagName);
        return child == null ? null : child.getTextContent();
    }

    public static String getText(Element element, String tagName, String defaultValue) {
        Element child = XmlKit.getElement(element, tagName);
        return child == null ? defaultValue : child.getTextContent();
    }

    public static List<Element> transElements(NodeList nodeList) {
        return XmlKit.transElements(null, nodeList);
    }

    public static List<Element> transElements(Element parentEle, NodeList nodeList) {
        int length = nodeList.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            Element element = (Element)nodeList.item(i);
            if (parentEle != null && element.getParentNode() != parentEle) continue;
            elements.add(element);
        }
        return elements;
    }

    public static Object getByXPath(String expression, Object source, QName returnType) {
        XPath xPath = XmlKit.createXPath();
        try {
            if (source instanceof InputSource) {
                return xPath.evaluate(expression, (InputSource)source, returnType);
            }
            return xPath.evaluate(expression, source, returnType);
        }
        catch (XPathExpressionException e) {
            throw new InstrumentException(e);
        }
    }

    public static Element getElementByXPath(String expression, Object source) {
        return (Element)XmlKit.getNodeByXPath(expression, source);
    }

    public static NodeList getNodeListByXPath(String expression, Object source) {
        return (NodeList)XmlKit.getByXPath(expression, source, XPathConstants.NODESET);
    }

    public static Node getNodeByXPath(String expression, Object source) {
        return (Node)XmlKit.getByXPath(expression, source, XPathConstants.NODE);
    }

    public static Map<String, Object> xmlToMap(String xmlStr) {
        return XmlKit.xmlToMap(xmlStr, new HashMap<String, Object>());
    }

    public static Map<String, Object> xmlToMap(Node node) {
        return XmlKit.xmlToMap(node, new HashMap<String, Object>());
    }

    public static Map<String, Object> xmlToMap(String xmlStr, Map<String, Object> result) {
        Document doc = XmlKit.parseXml(xmlStr);
        Element root = XmlKit.getElement(doc);
        root.normalize();
        return XmlKit.xmlToMap(root, result);
    }

    public static Map<String, Object> xmlToMap(Node node, Map<String, Object> result) {
        if (null == result) {
            result = new HashMap<String, Object>();
        }
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = nodeList.item(i);
            if (!XmlKit.isElement(childNode)) continue;
            Element childEle = (Element)childNode;
            result.put(childEle.getNodeName(), childEle.getTextContent());
        }
        return result;
    }

    public static <T> T xmlToBean(Node node, Class<T> bean) {
        Map<String, Object> map = XmlKit.xmlToMap(node);
        if (null != map && map.size() == 1) {
            return BeanKit.toBean(map.get(bean.getSimpleName()), bean);
        }
        return BeanKit.toBean(map, bean);
    }

    public static Object xmlToBean(String text, Object javaBean) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{javaBean.getClass()});
            Unmarshaller um = jaxbContext.createUnmarshaller();
            return um.unmarshal((InputStream)new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));
        }
        catch (JAXBException e) {
            throw new InstrumentException(e);
        }
    }

    public static Object xmlToBean(String text, Object javaBean, String charset) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{javaBean.getClass()});
            Unmarshaller um = jaxbContext.createUnmarshaller();
            return um.unmarshal((InputStream)new ByteArrayInputStream(text.getBytes(charset)));
        }
        catch (UnsupportedEncodingException | JAXBException e) {
            throw new InstrumentException(e);
        }
    }

    public static Object xmlToObject(String xml, Class clazz) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader sr = new StringReader(xml);
            return unmarshaller.unmarshal((Reader)sr);
        }
        catch (JAXBException e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> List<T> xmlToList(String xml, String rel, Class<T> clazz) {
        return XmlKit.xmlToList(xml, rel, clazz, true);
    }

    public static <T> List<T> xmlToList(String xml, String rel, Class<T> clazz, boolean isSelect) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller um = jaxbContext.createUnmarshaller();
            if (xml != null && xml.contains(rel)) {
                String[] entrys;
                String start_tag = "<" + rel + ">";
                if (isSelect) {
                    start_tag = "<" + rel + " action=\"select\"" + ">";
                }
                String end_tag = "</" + rel + ">";
                for (String val : entrys = xml.split(end_tag)) {
                    if (null == val || !val.contains(start_tag)) continue;
                    String once = val.substring(val.indexOf(start_tag)) + end_tag;
                    Object ob = um.unmarshal((InputStream)new ByteArrayInputStream(once.getBytes(Charset.UTF_8)));
                    list.add(ob);
                }
            }
            return list;
        }
        catch (JAXBException e) {
            throw new InstrumentException(e);
        }
    }

    public static String beanToXml(Object object) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller m = context.createMarshaller();
        StringWriter sw = new StringWriter();
        m.marshal(object, (Writer)sw);
        return sw.toString();
    }

    public static String beanToXml(Object object, Map<String, Object> map, Marshaller.Listener listener) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller marshaller = context.createMarshaller();
        if (MapKit.isNotEmpty(map)) {
            map.forEach((key, value) -> {
                try {
                    marshaller.setProperty(key, value);
                }
                catch (PropertyException e) {
                    throw new InstrumentException(e);
                }
            });
        }
        if (Objects.nonNull(listener)) {
            marshaller.setListener(listener);
        }
        StringWriter sw = new StringWriter();
        marshaller.marshal(object, (Writer)sw);
        return sw.toString();
    }

    public static String mapToXml(Map<String, Object> map) {
        StringBuffer sb = new StringBuffer();
        Set<String> set = map.keySet();
        for (String key : set) {
            String value;
            String string = value = null != map.get(key) ? map.get(key) : " ";
            if ("sign".equals(key)) continue;
            sb.append("<" + key + ">" + value + "<" + '/' + key + ">");
        }
        return sb.toString();
    }

    public static Document mapToXml(Map<?, ?> data, String rootName) {
        Document doc = XmlKit.createXml();
        Element root = XmlKit.appendChild(doc, rootName);
        XmlKit.mapToXml(doc, root, data);
        return doc;
    }

    private static void mapToXml(Document doc, Element element, Map<?, ?> data) {
        for (Map.Entry<?, ?> entry : data.entrySet()) {
            Element filedEle = doc.createElement(entry.getKey().toString());
            element.appendChild(filedEle);
            Object value = entry.getValue();
            if (value instanceof Map) {
                XmlKit.mapToXml(doc, filedEle, (Map)value);
                element.appendChild(filedEle);
                continue;
            }
            filedEle.appendChild(doc.createTextNode(value.toString()));
        }
    }

    public static String escapeToXml(String xml) {
        return xml.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"");
    }

    public static String caseToXml(String xml) {
        Pattern pattern = Pattern.compile("<.+?>");
        StringBuilder res = new StringBuilder();
        int lastIdx = 0;
        Matcher matchr = pattern.matcher(xml);
        while (matchr.find()) {
            String str = matchr.group();
            res.append(xml, lastIdx, matchr.start());
            res.append(str.toLowerCase());
            lastIdx = matchr.end();
        }
        res.append(xml.substring(lastIdx));
        return res.toString();
    }

    public static String getField(String xml, String field) {
        String[] entrys;
        String s1 = xml.replace("<map>", "");
        String s2 = s1.replace("</map>", "");
        for (String s : entrys = s2.split("</entry>")) {
            if (!s.contains(field)) continue;
            return s.substring(s.indexOf(">") + 1);
        }
        return "";
    }

    public static DocumentBuilder builder() {
        DocumentBuilder builder;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        XmlKit.disableXXE(dbf);
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new InstrumentException("Create xml document error!");
        }
        return builder;
    }

    public static XPath createXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public static String cleanInvalid(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return xmlContent.replaceAll("[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]", "");
    }

    public static String cleanComment(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return xmlContent.replaceAll("(?s)<!--.+?-->", "");
    }

    public static boolean isElement(Node node) {
        return null != node && 1 == node.getNodeType();
    }

    public static Element appendChild(Node node, String tagName) {
        Document doc = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element child = doc.createElement(tagName);
        node.appendChild(child);
        return child;
    }

    public static String escape(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int length = string.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static DocumentBuilderFactory disableXXE(DocumentBuilderFactory dbf) {
        try {
            String feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(feature, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return dbf;
    }
}

