/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron;

import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.cron.Scheduler;
import org.aoju.bus.cron.factory.Task;
import org.aoju.bus.cron.pattern.CronPattern;

public class Repertoire {
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Scheduler scheduler;
    private TimeZone timezone;
    private List<String> ids = new ArrayList<String>();
    private List<CronPattern> patterns = new ArrayList<CronPattern>();
    private List<Task> tasks = new ArrayList<Task>();
    private int size;

    public Repertoire(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.timezone = scheduler.getTimeZone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repertoire add(String id, CronPattern pattern, Task task) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            if (this.ids.contains(id)) {
                throw new InstrumentException("Id [{}] has been existed!", id);
            }
            this.ids.add(id);
            this.patterns.add(pattern);
            this.tasks.add(task);
            ++this.size;
        }
        finally {
            writeLock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            int index = this.ids.indexOf(id);
            if (index > -1) {
                this.tasks.remove(index);
                this.patterns.remove(index);
                this.ids.remove(index);
                --this.size;
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePattern(String id, CronPattern pattern) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            int index = this.ids.indexOf(id);
            if (index > -1) {
                this.patterns.set(index, pattern);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getTask(int index) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Task task = this.tasks.get(index);
            return task;
        }
        finally {
            readLock.unlock();
        }
    }

    public Task getTask(String id) {
        int index = this.ids.indexOf(id);
        if (index > -1) {
            return this.getTask(index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CronPattern getPattern(int index) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            CronPattern cronPattern = this.patterns.get(index);
            return cronPattern;
        }
        finally {
            readLock.unlock();
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size < 1;
    }

    public CronPattern getPattern(String id) {
        int index = this.ids.indexOf(id);
        if (index > -1) {
            return this.getPattern(index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTaskIfMatch(long millis) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            this.executeTaskIfMatchInternal(millis);
        }
        finally {
            readLock.unlock();
        }
    }

    protected void executeTaskIfMatchInternal(long millis) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.patterns.get(i).match(this.timezone, millis, this.scheduler.matchSecond)) continue;
            this.scheduler.manager.spawnExecutor(this.tasks.get(i));
        }
    }
}

