/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.builtin.software;

import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.builtin.software.OSThread;

@ThreadSafe
public interface OSProcess {
    public String getName();

    public String getPath();

    public String getCommandLine();

    public String getCurrentWorkingDirectory();

    public String getUser();

    public String getUserID();

    public String getGroup();

    public String getGroupID();

    public State getState();

    public int getProcessID();

    public int getParentProcessID();

    public int getThreadCount();

    public int getPriority();

    public long getVirtualSize();

    public long getResidentSetSize();

    public long getKernelTime();

    public long getUserTime();

    public long getUpTime();

    public long getStartTime();

    public long getBytesRead();

    public long getBytesWritten();

    public long getOpenFiles();

    public double getProcessCpuLoadCumulative();

    public double getProcessCpuLoadBetweenTicks(OSProcess var1);

    public int getBitness();

    public long getAffinityMask();

    public boolean updateAttributes();

    public List<OSThread> getThreadDetails();

    public long getMinorFaults();

    public long getMajorFaults();

    public static enum State {
        NEW,
        RUNNING,
        SLEEPING,
        WAITING,
        ZOMBIE,
        STOPPED,
        OTHER,
        INVALID;

    }
}

