/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger;

import org.aoju.bus.logger.LogFactory;

public class GlobalFactory {
    private static final Object lock = new Object();
    private static volatile LogFactory currentLogFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFactory get() {
        if (null == currentLogFactory) {
            Object object = lock;
            synchronized (object) {
                if (null == currentLogFactory) {
                    currentLogFactory = LogFactory.create();
                }
            }
        }
        return currentLogFactory;
    }

    public static LogFactory set(Class<? extends LogFactory> logFactoryClass) {
        try {
            return GlobalFactory.set(logFactoryClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not instance LogFactory class!", e);
        }
    }

    public static LogFactory set(LogFactory logFactory) {
        logFactory.getLog(GlobalFactory.class).debug("Custom Use [{}] Logger.", logFactory.name);
        currentLogFactory = logFactory;
        return currentLogFactory;
    }
}

