/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.dingtalk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.AbstractProvider;
import org.aoju.bus.notify.provider.dingtalk.DingTalkProperty;

public class DingTalkProvider
extends AbstractProvider<DingTalkProperty, Context> {
    private static final String SUCCESS_RESULT = "200";
    private static final String DINGTALK_TOKEN_API = "https://oapi.dingtalk.com/gettoken";
    private static final String DingTalk_NOTIFY_API = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2";
    private AtomicReference<String> accessToken = new AtomicReference();
    private long refreshTokenTime;
    private long tokenTimeOut = Duration.ofSeconds(7000L).toMillis();

    public DingTalkProvider(Context properties) {
        super(properties);
    }

    @Override
    public Message send(DingTalkProperty entity) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("access_token", entity.getToken());
        param.put("agent_id", entity.getAgentId());
        param.put("msg", entity.getMsg());
        if (StringKit.isNotBlank(entity.getUserIdList())) {
            param.put("userid_list", entity.getUserIdList());
        }
        if (StringKit.isNotBlank(entity.getDeptIdList())) {
            param.put("dept_id_list", entity.getDeptIdList());
        }
        param.put("to_all_user", entity.isToAllUser());
        String response = Httpx.post(DingTalk_NOTIFY_API, param);
        JSONObject object = JSON.parseObject((String)response);
        return Message.builder().errcode(SUCCESS_RESULT.equals(object.getString("errcode")) ? Builder.ErrorCode.SUCCESS.getCode() : object.getString("errcode")).errmsg(object.getString("errmsg")).build();
    }

    private String getToken() {
        if (System.currentTimeMillis() - this.refreshTokenTime > this.tokenTimeOut || this.accessToken.get() == null) {
            return this.requestToken();
        }
        return this.accessToken.get();
    }

    private String requestToken() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("corpid", this.properties.getAppKey());
        paramMap.put("corpsecret", this.properties.getAppSecret());
        String response = Httpx.get(DINGTALK_TOKEN_API, paramMap);
        JSONObject object = JSON.parseObject((String)response);
        if (SUCCESS_RESULT.equals(object.getString("errcode"))) {
            String token = object.getString("access_token");
            this.refreshTokenTime = System.currentTimeMillis();
            this.accessToken.set(token);
            return token;
        }
        Logger.error("\u83b7\u53d6\u9489\u9489token\u5931\u8d25\uff1a{}", object.getString("errmsg"));
        return null;
    }

    public void setAccessToken(AtomicReference<String> accessToken) {
        this.accessToken = accessToken;
    }

    public void setRefreshTokenTime(long refreshTokenTime) {
        this.refreshTokenTime = refreshTokenTime;
    }

    public void setTokenTimeOut(long tokenTimeOut) {
        this.tokenTimeOut = tokenTimeOut;
    }
}

