/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class QqProvider
extends AbstractProvider {
    public QqProvider(Context context) {
        super(context, Registry.QQ);
    }

    public QqProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.QQ, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        return this.getAuthToken(this.doGetAuthorizationCode(callback.getCode()));
    }

    @Override
    public Message refresh(AccToken accToken) {
        String response = Httpx.get(this.refreshTokenUrl(accToken.getRefreshToken()));
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getAuthToken(response)).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        String openId = this.getOpenId(accToken);
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(accToken));
        if (object.getIntValue("ret") != 0) {
            throw new AuthorizedException(object.getString("msg"));
        }
        String avatar = object.getString("figureurl_qq_2");
        if (StringKit.isEmpty(avatar)) {
            avatar = object.getString("figureurl_qq_1");
        }
        String location = String.format("%s-%s", object.getString("province"), object.getString("city"));
        return Property.builder().rawJson(object).username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(avatar).location(location).uuid(openId).gender(Normal.Gender.getGender(object.getString("gender"))).token(accToken).source(this.source.toString()).build();
    }

    private String getOpenId(AccToken accToken) {
        String response = Httpx.get(Builder.fromUrl("https://graph.qq.com/oauth2.0/me").queryParam("access_token", accToken.getAccessToken()).queryParam("unionid", this.context.isUnionId() ? 1 : 0).build());
        String removePrefix = StringKit.replace(response, "callback(", "");
        String removeSuffix = StringKit.replace(removePrefix, ");", "");
        String openId = StringKit.trim(removeSuffix);
        JSONObject object = JSONObject.parseObject((String)openId);
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.get((Object)"error") + ":" + object.get((Object)"error_description"));
        }
        accToken.setOpenId(object.getString("openid"));
        if (object.containsKey((Object)"unionid")) {
            accToken.setUnionId(object.getString("unionid"));
        }
        return StringKit.isEmpty(accToken.getUnionId()) ? accToken.getOpenId() : accToken.getUnionId();
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", accToken.getAccessToken()).queryParam("oauth_consumer_key", this.context.getAppKey()).queryParam("openid", accToken.getOpenId()).build();
    }

    private AccToken getAuthToken(String response) {
        Map<String, String> accessTokenObject = UriKit.decodeVal(response, "UTF-8");
        if (!accessTokenObject.containsKey("access_token") || accessTokenObject.containsKey("code")) {
            throw new AuthorizedException(accessTokenObject.get("msg"));
        }
        return AccToken.builder().accessToken(accessTokenObject.get("access_token")).expireIn(Integer.parseInt(accessTokenObject.getOrDefault("expires_in", "0"))).refreshToken(accessTokenObject.get("refresh_token")).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, QqProvider.getScopes(true, OauthScope.Qq.values()))).build();
    }
}

