/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.office.support.excel.CellKit;
import org.aoju.bus.office.support.excel.ExcelKit;
import org.aoju.bus.office.support.excel.RowKit;
import org.aoju.bus.office.support.excel.StyleKit;
import org.aoju.bus.office.support.excel.WorksKit;
import org.aoju.bus.office.support.excel.cell.CellLocation;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelBase<T extends ExcelBase<T>>
implements Closeable {
    protected boolean isClosed;
    protected Workbook workbook;
    protected Sheet sheet;

    public ExcelBase(Sheet sheet) {
        Assert.notNull(sheet, "No Sheet provided.", new Object[0]);
        this.sheet = sheet;
        this.workbook = sheet.getWorkbook();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public int getSheetCount() {
        return this.workbook.getNumberOfSheets();
    }

    public List<Sheet> getSheets() {
        int totalSheet = this.getSheetCount();
        ArrayList<Sheet> result = new ArrayList<Sheet>(totalSheet);
        for (int i = 0; i < totalSheet; ++i) {
            result.add(this.workbook.getSheetAt(i));
        }
        return result;
    }

    public List<String> getSheetNames() {
        int totalSheet = this.workbook.getNumberOfSheets();
        ArrayList<String> result = new ArrayList<String>(totalSheet);
        for (int i = 0; i < totalSheet; ++i) {
            result.add(this.workbook.getSheetAt(i).getSheetName());
        }
        return result;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public T setSheet(String sheetName) {
        return this.setSheet(WorksKit.getOrCreateSheet(this.workbook, sheetName));
    }

    public T setSheet(int sheetIndex) {
        return this.setSheet(WorksKit.getOrCreateSheet(this.workbook, sheetIndex));
    }

    public T setSheet(Sheet sheet) {
        this.sheet = sheet;
        return (T)this;
    }

    public Cell getCell(int x, int y) {
        return this.getCell(x, y, false);
    }

    public Cell getCell(String locationRef) {
        CellLocation cellLocation = ExcelKit.toLocation(locationRef);
        return this.getCell(cellLocation.getX(), cellLocation.getY());
    }

    public Cell getOrCreateCell(int x, int y) {
        return this.getCell(x, y, true);
    }

    public Cell getOrCreateCell(String locationRef) {
        CellLocation cellLocation = ExcelKit.toLocation(locationRef);
        return this.getOrCreateCell(cellLocation.getX(), cellLocation.getY());
    }

    public Cell getCell(int x, int y, boolean isCreateIfNotExist) {
        Row row;
        Row row2 = row = isCreateIfNotExist ? RowKit.getOrCreateRow(this.sheet, y) : this.sheet.getRow(y);
        if (null != row) {
            return isCreateIfNotExist ? CellKit.getOrCreateCell(row, x) : row.getCell(x);
        }
        return null;
    }

    public Cell getCell(String locationRef, boolean isCreateIfNotExist) {
        CellLocation cellLocation = ExcelKit.toLocation(locationRef);
        return this.getCell(cellLocation.getX(), cellLocation.getY(), isCreateIfNotExist);
    }

    public Row getOrCreateRow(int y) {
        return RowKit.getOrCreateRow(this.sheet, y);
    }

    public CellStyle getOrCreateCellStyle(int x, int y) {
        Cell cell = this.getOrCreateCell(x, y);
        CellStyle cellStyle = cell.getCellStyle();
        if (null == cellStyle) {
            cellStyle = this.workbook.createCellStyle();
            cell.setCellStyle(cellStyle);
        }
        return cellStyle;
    }

    public CellStyle getOrCreateRowStyle(int y) {
        Row row = this.getOrCreateRow(y);
        CellStyle rowStyle = row.getRowStyle();
        if (null == rowStyle) {
            rowStyle = this.workbook.createCellStyle();
            row.setRowStyle(rowStyle);
        }
        return rowStyle;
    }

    public CellStyle getOrCreateCellStyle(String locationRef) {
        CellLocation cellLocation = ExcelKit.toLocation(locationRef);
        return this.getOrCreateCellStyle(cellLocation.getX(), cellLocation.getY());
    }

    public CellStyle getOrCreateColumnStyle(int x) {
        CellStyle columnStyle = this.sheet.getColumnStyle(x);
        if (null == columnStyle) {
            columnStyle = this.workbook.createCellStyle();
            this.sheet.setDefaultColumnStyle(x, columnStyle);
        }
        return columnStyle;
    }

    public CellStyle createCellStyle(int x, int y) {
        Cell cell = this.getOrCreateCell(x, y);
        CellStyle cellStyle = this.workbook.createCellStyle();
        cell.setCellStyle(cellStyle);
        return cellStyle;
    }

    public CellStyle createCellStyle(String locationRef) {
        CellLocation cellLocation = ExcelKit.toLocation(locationRef);
        return this.createCellStyle(cellLocation.getX(), cellLocation.getY());
    }

    public CellStyle createCellStyle() {
        return StyleKit.createCellStyle(this.workbook);
    }

    public int getRowCount() {
        return this.sheet.getLastRowNum() + 1;
    }

    public int getPhysicalRowCount() {
        return this.sheet.getPhysicalNumberOfRows();
    }

    public int getColumnCount() {
        return this.getColumnCount(0);
    }

    public int getColumnCount(int rowNum) {
        return this.sheet.getRow(rowNum).getLastCellNum();
    }

    @Override
    public void close() {
        IoKit.close((Closeable)this.workbook);
        this.sheet = null;
        this.workbook = null;
        this.isClosed = true;
    }
}

