/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.dialect.postgresql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.shade.screw.dialect.AbstractDatabaseQuery;
import org.aoju.bus.shade.screw.dialect.postgresql.PostgreSqlColumn;
import org.aoju.bus.shade.screw.dialect.postgresql.PostgreSqlDatabase;
import org.aoju.bus.shade.screw.dialect.postgresql.PostgreSqlPrimaryKey;
import org.aoju.bus.shade.screw.dialect.postgresql.PostgreSqlTable;
import org.aoju.bus.shade.screw.mapping.Mapping;
import org.aoju.bus.shade.screw.metadata.Column;
import org.aoju.bus.shade.screw.metadata.Database;
import org.aoju.bus.shade.screw.metadata.PrimaryKey;

public class PostgreSqlDataBaseQuery
extends AbstractDatabaseQuery {
    public PostgreSqlDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws InstrumentException {
        PostgreSqlDatabase model = new PostgreSqlDatabase();
        model.setDatabase(this.getCatalog());
        return model;
    }

    public List<PostgreSqlTable> getTables() throws InstrumentException {
        List<PostgreSqlTable> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), "%", new String[]{"TABLE"});
            list = Mapping.convertList(resultSet, PostgreSqlTable.class);
        }
        catch (SQLException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                PostgreSqlDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        PostgreSqlDataBaseQuery.close(resultSet);
        return list;
    }

    public List<PostgreSqlColumn> getTableColumns(String table) throws InstrumentException {
        List<PostgreSqlColumn> list;
        Assert.notEmpty(table, "Table name can not be empty!", new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
            List<PostgreSqlColumn> list2 = Mapping.convertList(resultSet, PostgreSqlColumn.class);
            List<String> tableNames = list2.stream().map(PostgreSqlColumn::getTableName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            if (CollKit.isEmpty(this.columnsCaching)) {
                String sql;
                if (table.equals("%")) {
                    sql = "SELECT \"TABLE_NAME\", \"TABLE_SCHEMA\", \"COLUMN_NAME\", \"LENGTH\", concat(\"UDT_NAME\", case when \"LENGTH\" isnull then '' else concat('(', concat(\"LENGTH\", ')')) end) \"COLUMN_TYPE\" FROM(select table_schema as \"TABLE_SCHEMA\", column_name as \"COLUMN_NAME\", table_name as \"TABLE_NAME\", udt_name as \"UDT_NAME\", case when coalesce(character_maximum_length, numeric_precision, -1) = -1 then null else coalesce(character_maximum_length, numeric_precision, -1) end as \"LENGTH\" from information_schema.columns a where  table_schema = '%s' and table_catalog = '%s') t";
                    PreparedStatement statement = this.prepareStatement(String.format(sql, this.getSchema(), this.getDataBase().getDatabase()));
                    resultSet = statement.executeQuery();
                    int fetchSize = 4284;
                    if (resultSet.getFetchSize() < fetchSize) {
                        resultSet.setFetchSize(fetchSize);
                    }
                } else {
                    sql = "SELECT \"TABLE_NAME\", \"TABLE_SCHEMA\", \"COLUMN_NAME\", \"LENGTH\", concat(\"UDT_NAME\", case when \"LENGTH\" isnull then '' else concat('(', concat(\"LENGTH\", ')')) end) \"COLUMN_TYPE\" FROM(select table_schema as \"TABLE_SCHEMA\", column_name as \"COLUMN_NAME\", table_name as \"TABLE_NAME\", udt_name as \"UDT_NAME\", case when coalesce(character_maximum_length, numeric_precision, -1) = -1 then null else coalesce(character_maximum_length, numeric_precision, -1) end as \"LENGTH\" from information_schema.columns a where table_name = '%s' and table_schema = '%s' and table_catalog = '%s') t";
                    resultSet = this.prepareStatement(String.format(sql, table, this.getSchema(), this.getDataBase().getDatabase())).executeQuery();
                }
                List<PostgreSqlColumn> inquires = Mapping.convertList(resultSet, PostgreSqlColumn.class);
                tableNames.forEach(name -> this.columnsCaching.put(name, inquires.stream().filter(i -> i.getTableName().equals(name)).collect(Collectors.toList())));
            }
            list2.forEach(i -> {
                List columns = (List)this.columnsCaching.get(i.getTableName());
                columns.forEach(j -> {
                    if (i.getColumnName().equals(j.getColumnName()) && i.getTableName().equals(j.getTableName())) {
                        i.setColumnLength(j.getColumnLength());
                        i.setColumnType(j.getColumnType());
                    }
                });
            });
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                PostgreSqlDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        PostgreSqlDataBaseQuery.close(resultSet);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns() throws InstrumentException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws InstrumentException {
        List<PostgreSqlPrimaryKey> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList(resultSet, PostgreSqlPrimaryKey.class);
        }
        catch (SQLException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                PostgreSqlDataBaseQuery.close(resultSet, this.connection);
                throw throwable;
            }
        }
        PostgreSqlDataBaseQuery.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws InstrumentException {
        List<PostgreSqlPrimaryKey> list;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT result.TABLE_CAT, result.TABLE_SCHEM, result.TABLE_NAME, result.COLUMN_NAME, result.KEY_SEQ, result.PK_NAME FROM(SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ct.relname AS TABLE_NAME, a.attname AS COLUMN_NAME, (information_schema._pg_expandarray(i.indkey)).n AS KEY_SEQ, ci.relname AS PK_NAME, information_schema._pg_expandarray(i.indkey) AS KEYS, a.attnum AS A_ATTNUM FROM pg_catalog.pg_class ct JOIN pg_catalog.pg_attribute a ON (ct.oid = a.attrelid) JOIN pg_catalog.pg_namespace n ON (ct.relnamespace = n.oid) JOIN pg_catalog.pg_index i ON (a.attrelid = i.indrelid) JOIN pg_catalog.pg_class ci ON (ci.oid = i.indexrelid) WHERE true AND n.nspname = 'public' AND i.indisprimary) result where result.A_ATTNUM = (result.KEYS).x ORDER BY result.table_name, result.pk_name, result.key_seq";
            resultSet = this.prepareStatement(sql).executeQuery();
            list = Mapping.convertList(resultSet, PostgreSqlPrimaryKey.class);
        }
        catch (SQLException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                PostgreSqlDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        PostgreSqlDataBaseQuery.close(resultSet);
        return list;
    }
}

