/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;
import org.aoju.bus.socket.origin.AioQuickClient;
import org.aoju.bus.socket.origin.AioSession;
import org.aoju.bus.socket.origin.Message;
import org.aoju.bus.socket.origin.Protocol;
import org.aoju.bus.socket.origin.SSLAioSession;
import org.aoju.bus.socket.origin.TcpReadHandler;
import org.aoju.bus.socket.origin.TcpWriteHandler;
import org.aoju.bus.socket.origin.plugins.ssl.SSLConfig;
import org.aoju.bus.socket.origin.plugins.ssl.SSLService;

public final class AioSSLQuickClient<T>
extends AioQuickClient<T> {
    private SSLService sslService;
    private SSLConfig sslConfig = new SSLConfig();

    public AioSSLQuickClient(String host, int port, Protocol<T> protocol, Message<T> messageProcessor) {
        super(host, port, protocol, messageProcessor);
    }

    @Override
    public AioSession<T> start(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException, ExecutionException, InterruptedException {
        this.sslConfig.setClientMode(true);
        this.sslService = new SSLService(this.sslConfig);
        AsynchronousSocketChannel socketChannel = AsynchronousSocketChannel.open(asynchronousChannelGroup);
        socketChannel.connect(new InetSocketAddress(this.config.getHost(), this.config.getPort())).get();
        this.session = new SSLAioSession(socketChannel, this.config, new TcpReadHandler(), new TcpWriteHandler(), this.sslService, this.bufferPool.allocateBufferPage());
        this.session.initSession();
        return this.session;
    }

    public AioSSLQuickClient<T> setKeyStore(String keyStoreFile, String keystorePassword) {
        this.sslConfig.setKeyFile(keyStoreFile);
        this.sslConfig.setKeystorePassword(keystorePassword);
        return this;
    }

    public AioSSLQuickClient<T> setKeyPassword(String keyPassword) {
        this.sslConfig.setKeyPassword(keyPassword);
        return this;
    }

    public AioSSLQuickClient<T> setTrust(String trustFile, String trustPassword) {
        this.sslConfig.setTrustFile(trustFile);
        this.sslConfig.setTrustPassword(trustPassword);
        return this;
    }
}

