/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans;

import java.beans.Transient;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aoju.bus.core.annotation.Ignore;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.map.CaseInsensitiveMap;
import org.aoju.bus.core.toolkit.AnnoKit;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.BooleanKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class BeanDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Class<?> beanClass;
    private Map<String, PropDesc> propMap = new LinkedHashMap<String, PropDesc>();

    public BeanDesc(Class<?> beanClass) {
        Assert.notNull(beanClass);
        this.beanClass = beanClass;
        this.init();
    }

    public String getName() {
        return this.beanClass.getName();
    }

    public String getSimpleName() {
        return this.beanClass.getSimpleName();
    }

    public Map<String, PropDesc> getPropMap(boolean ignoreCase) {
        return ignoreCase ? new CaseInsensitiveMap<String, PropDesc>(1.0f, this.propMap) : this.propMap;
    }

    public Collection<PropDesc> getProps() {
        return this.propMap.values();
    }

    public PropDesc getProp(String fieldName) {
        return this.propMap.get(fieldName);
    }

    public Field getField(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getField();
    }

    public Method getGetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getGetter();
    }

    public Method getSetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getSetter();
    }

    private BeanDesc init() {
        Method[] methods = ReflectKit.getMethods(this.beanClass);
        for (Field field : ReflectKit.getFields(this.beanClass)) {
            if (BeanKit.isStatic(field)) continue;
            PropDesc prop = this.createProp(field, methods);
            this.propMap.putIfAbsent(prop.getFieldName(), prop);
        }
        return this;
    }

    private PropDesc createProp(Field field, Method[] methods) {
        PropDesc prop = this.findProp(field, methods, false);
        if (null == prop.getter || null == prop.setter) {
            PropDesc propIgnoreCase = this.findProp(field, methods, true);
            if (null == prop.getter) {
                prop.getter = propIgnoreCase.getter;
            }
            if (null == prop.setter) {
                prop.setter = propIgnoreCase.setter;
            }
        }
        return prop;
    }

    private PropDesc findProp(Field field, Method[] methods, boolean ignoreCase) {
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        boolean isBooleanField = BooleanKit.isBoolean(fieldType);
        Method getter = null;
        Method setter = null;
        for (Method method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length > 1) continue;
            String methodName = method.getName();
            if (parameterTypes.length == 0) {
                if (this.isMatchGetter(methodName, fieldName, isBooleanField, ignoreCase)) {
                    getter = method;
                }
            } else if (this.isMatchSetter(methodName, fieldName, isBooleanField, ignoreCase)) {
                setter = method;
            }
            if (null != getter && null != setter) break;
        }
        return new PropDesc(field, getter, setter);
    }

    private boolean isMatchGetter(String methodName, String fieldName, boolean isBooleanField, boolean ignoreCase) {
        if (ignoreCase) {
            methodName = methodName.toLowerCase();
            fieldName = fieldName.toLowerCase();
        } else {
            fieldName = StringKit.upperFirst(fieldName);
        }
        if (!methodName.startsWith("get") && !methodName.startsWith("is")) {
            return false;
        }
        if ("getclass".equals(methodName)) {
            return false;
        }
        if (isBooleanField && (fieldName.startsWith("is") ? methodName.equals(fieldName) || methodName.equals("get" + fieldName) || methodName.equals("is" + fieldName) : methodName.equals("is" + fieldName))) {
            return true;
        }
        return methodName.equals("get" + fieldName);
    }

    private boolean isMatchSetter(String methodName, String fieldName, boolean isBooleanField, boolean ignoreCase) {
        methodName = methodName.toLowerCase();
        fieldName = fieldName.toLowerCase();
        if (ignoreCase) {
            methodName = methodName.toLowerCase();
            fieldName = fieldName.toLowerCase();
        } else {
            fieldName = StringKit.upperFirst(fieldName);
        }
        if (!methodName.startsWith("set")) {
            return false;
        }
        if (isBooleanField && fieldName.startsWith("is") && (methodName.equals("set" + StringKit.removePrefix(fieldName, "is")) || methodName.equals("set" + fieldName))) {
            return true;
        }
        return methodName.equals("set" + fieldName);
    }

    public static class PropDesc {
        protected final Field field;
        protected Method getter;
        protected Method setter;

        public PropDesc(Field field, Method getter, Method setter) {
            this.field = field;
            this.getter = ClassKit.setAccessible(getter);
            this.setter = ClassKit.setAccessible(setter);
        }

        public String getFieldName() {
            return ReflectKit.getFieldName(this.field);
        }

        public String getRawFieldName() {
            return null == this.field ? null : this.field.getName();
        }

        public Field getField() {
            return this.field;
        }

        public Type getFieldType() {
            if (null != this.field) {
                return TypeKit.getType(this.field);
            }
            return this.findPropType(this.getter, this.setter);
        }

        public Class<?> getFieldClass() {
            if (null != this.field) {
                return TypeKit.getClass(this.field);
            }
            return this.findPropClass(this.getter, this.setter);
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        public boolean isReadable(boolean checkTransient) {
            if (null == this.getter && !BeanKit.isPublic(this.field)) {
                return false;
            }
            if (checkTransient && this.isTransientForGet()) {
                return false;
            }
            return false == this.isIgnoreGet();
        }

        public Object getValue(Object bean) {
            if (null != this.getter) {
                return ReflectKit.invoke(bean, this.getter, new Object[0]);
            }
            if (BeanKit.isPublic(this.field)) {
                return ReflectKit.getFieldValue(bean, this.field);
            }
            return null;
        }

        public Object getValue(Object bean, Type targetType, boolean ignoreError) {
            Object convertValue;
            Object result;
            block3: {
                result = null;
                try {
                    result = this.getValue(bean);
                }
                catch (Exception e) {
                    if (ignoreError) break block3;
                    throw new InstrumentException("Get value of [{}] error!", this.getFieldName());
                }
            }
            if (null != result && null != targetType && null != (convertValue = Convert.convertWithCheck(targetType, result, null, ignoreError))) {
                result = convertValue;
            }
            return result;
        }

        public boolean isWritable(boolean checkTransient) {
            if (null == this.setter && !BeanKit.isPublic(this.field)) {
                return false;
            }
            if (checkTransient && this.isTransientForSet()) {
                return false;
            }
            return false == this.isIgnoreSet();
        }

        public PropDesc setValue(Object bean, Object value) {
            if (null != this.setter) {
                ReflectKit.invoke(bean, this.setter, value);
            } else if (BeanKit.isPublic(this.field)) {
                ReflectKit.setFieldValue(bean, this.field, value);
            }
            return this;
        }

        public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError) {
            block5: {
                Class<?> propClass;
                if (ignoreNull && null == value) {
                    return this;
                }
                if (null != value && !(propClass = this.getFieldClass()).isInstance(value)) {
                    value = Convert.convertWithCheck(propClass, value, null, ignoreError);
                }
                if (null != value || !ignoreNull) {
                    try {
                        this.setValue(bean, value);
                    }
                    catch (Exception e) {
                        if (ignoreError) break block5;
                        throw new InstrumentException("Set value of [{}] error!", this.getFieldName());
                    }
                }
            }
            return this;
        }

        private Type findPropType(Method getter, Method setter) {
            Type type = null;
            if (null != getter) {
                type = TypeKit.getReturnType(getter);
            }
            if (null == type && null != setter) {
                type = TypeKit.getParamType(setter, 0);
            }
            return type;
        }

        private Class<?> findPropClass(Method getter, Method setter) {
            Class<?> type = null;
            if (null != getter) {
                type = TypeKit.getReturnClass(getter);
            }
            if (null == type && null != setter) {
                type = TypeKit.getFirstParamClass(setter);
            }
            return type;
        }

        private boolean isIgnoreSet() {
            return AnnoKit.hasAnnotation(this.field, Ignore.class) || AnnoKit.hasAnnotation(this.setter, Ignore.class);
        }

        private boolean isIgnoreGet() {
            return AnnoKit.hasAnnotation(this.field, Ignore.class) || AnnoKit.hasAnnotation(this.getter, Ignore.class);
        }

        private boolean isTransientForGet() {
            boolean isTransient = BeanKit.hasModifier(this.field, BeanKit.ModifierType.TRANSIENT);
            if (!isTransient && null != this.getter && !(isTransient = BeanKit.hasModifier(this.getter, BeanKit.ModifierType.TRANSIENT))) {
                isTransient = AnnoKit.hasAnnotation(this.getter, Transient.class);
            }
            return isTransient;
        }

        private boolean isTransientForSet() {
            boolean isTransient = BeanKit.hasModifier(this.field, BeanKit.ModifierType.TRANSIENT);
            if (!isTransient && null != this.setter && !(isTransient = BeanKit.hasModifier(this.setter, BeanKit.ModifierType.TRANSIENT))) {
                isTransient = AnnoKit.hasAnnotation(this.setter, Transient.class);
            }
            return isTransient;
        }
    }
}

