/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.aoju.bus.core.collection.EnumerationIter;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;

public class Scaner {
    private String packageName;
    private String packageNameWithDot;
    private String packageDirName;
    private String packagePath;
    private Filter<Class<?>> classFilter;
    private java.nio.charset.Charset charset;
    private boolean initialize;
    private Set<Class<?>> classes = new HashSet();

    public Scaner() {
        this(null);
    }

    public Scaner(String packageName) {
        this(packageName, null);
    }

    public Scaner(String packageName, Filter<Class<?>> classFilter) {
        this(packageName, classFilter, Charset.UTF_8);
    }

    public Scaner(String packageName, Filter<Class<?>> classFilter, java.nio.charset.Charset charset) {
        this.packageName = packageName = StringKit.nullToEmpty(packageName);
        this.packageNameWithDot = StringKit.addSuffixIfNot(packageName, ".");
        this.packageDirName = packageName.replace('.', File.separatorChar);
        this.packagePath = packageName.replace('.', '/');
        this.classFilter = classFilter;
        this.charset = charset;
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return Scaner.scanPackage(packageName, clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return Scaner.scanPackage(packageName, clazz -> superClass.isAssignableFrom((Class<?>)clazz) && !superClass.equals(clazz));
    }

    public static Set<Class<?>> scanPackage() {
        return Scaner.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return Scaner.scanPackage(packageName, null);
    }

    public static Set<Class<?>> scanPackage(String packageName, Filter<Class<?>> classFilter) {
        return new Scaner(packageName, classFilter).scan();
    }

    public Set<Class<?>> scan() {
        for (URL url : FileKit.getResourceIter(this.packagePath)) {
            switch (url.getProtocol()) {
                case "file": {
                    this.scanFile(new File(UriKit.decode(url.getFile(), this.charset.name())), null);
                    break;
                }
                case "jar": {
                    this.scanJar(UriKit.getJarFile(url));
                }
            }
        }
        if (CollKit.isEmpty(this.classes)) {
            this.scanJavaClassPaths();
        }
        return Collections.unmodifiableSet(this.classes);
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    private void scanJavaClassPaths() {
        String[] javaClassPaths;
        for (String classPath : javaClassPaths = ClassKit.getJavaClassPaths()) {
            classPath = UriKit.decode(classPath, Charset.systemCharsetName());
            this.scanFile(new File(classPath), null);
        }
    }

    private void scanFile(File file, String rootDir) {
        File[] files;
        if (file.isFile()) {
            String fileName = file.getAbsolutePath();
            if (fileName.endsWith(".class")) {
                String className = fileName.substring(rootDir.length(), fileName.length() - 6).replace(File.separatorChar, '.');
                this.addIfAccept(className);
            } else if (fileName.endsWith(".jar")) {
                try {
                    this.scanJar(new JarFile(file));
                }
                catch (IOException e) {
                    throw new InstrumentException(e);
                }
            }
        } else if (file.isDirectory() && null != (files = file.listFiles())) {
            for (File subFile : files) {
                this.scanFile(subFile, null == rootDir ? this.subPathBeforePackage(file) : rootDir);
            }
        }
    }

    private void scanJar(JarFile jar) {
        for (JarEntry entry : new EnumerationIter<JarEntry>(jar.entries())) {
            String name = StringKit.removePrefix(entry.getName(), "/");
            if (!name.startsWith(this.packagePath) || !name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(0, name.length() - 6).replace('/', '.');
            this.addIfAccept(this.loadClass(className));
        }
    }

    private Class<?> loadClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, this.initialize, ClassKit.getClassLoader());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clazz;
    }

    private void addIfAccept(String className) {
        int packageLen;
        if (StringKit.isBlank(className)) {
            return;
        }
        int classLen = className.length();
        if (classLen == (packageLen = this.packageName.length())) {
            if (className.equals(this.packageName)) {
                this.addIfAccept(this.loadClass(className));
            }
        } else if (classLen > packageLen && className.startsWith(this.packageNameWithDot)) {
            this.addIfAccept(this.loadClass(className));
        }
    }

    private void addIfAccept(Class<?> clazz) {
        Filter<Class<?>> classFilter;
        if (null != clazz && ((classFilter = this.classFilter) == null || classFilter.accept(clazz))) {
            this.classes.add(clazz);
        }
    }

    private String subPathBeforePackage(File file) {
        String filePath = file.getAbsolutePath();
        if (StringKit.isNotEmpty(this.packageDirName)) {
            filePath = StringKit.subBefore((CharSequence)filePath, this.packageDirName, true);
        }
        return StringKit.addSuffixIfNot(filePath, File.separator);
    }
}

