/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.text.Builders;
import org.aoju.bus.core.text.Similarity;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CharKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.TextKit;

public class StringKit {
    private static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;

    public static String trim(CharSequence str) {
        return null == str ? null : StringKit.trim(str, 0);
    }

    public static String trim(CharSequence str, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && CharKit.isBlankChar(str.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && CharKit.isBlankChar(str.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < length) {
            return str.toString().substring(start, end);
        }
        return str.toString();
    }

    public static String[] trim(String[] array) {
        if (ArrayKit.isEmpty(array)) {
            return array;
        }
        String[] resultArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String param = array[i];
            resultArray[i] = StringKit.trim(param);
        }
        return resultArray;
    }

    public static String trimToNull(CharSequence str) {
        String trimStr = StringKit.trim(str);
        return "".equals(trimStr) ? null : trimStr;
    }

    public static String trimToEmpty(String str) {
        return str == null ? "" : str.trim();
    }

    public static boolean isAllCharMatch(CharSequence value, org.aoju.bus.core.lang.Matcher<Character> matcher) {
        if (StringKit.isBlank(value)) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            if (matcher.match(Character.valueOf(value.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharKit.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StringKit.isBlank((CharSequence)obj);
        }
        return false;
    }

    public static boolean isNotBlank(CharSequence str) {
        return false == StringKit.isBlank(str);
    }

    public static boolean isAllNotBlank(CharSequence ... args) {
        return false == StringKit.hasBlank(args);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        if (ArrayKit.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringKit.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        if (ArrayKit.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringKit.isNotBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ArrayKit.isEmpty(css)) {
            return false;
        }
        for (CharSequence cs : css) {
            if (!StringKit.isBlank(cs)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isAllEmpty(CharSequence ... str) {
        if (ArrayKit.isEmpty(str)) {
            return true;
        }
        for (CharSequence val : str) {
            if (!StringKit.isNotEmpty(val)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(CharSequence ... args) {
        return false == StringKit.hasEmpty(args);
    }

    public static boolean hasEmpty(CharSequence ... strs) {
        if (ArrayKit.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringKit.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return false == StringKit.isEmpty(str);
    }

    public static String emptyIfNull(CharSequence str) {
        return StringKit.nullToEmpty(str);
    }

    public static boolean emptyIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        return false;
    }

    public static String nullToEmpty(CharSequence str) {
        return StringKit.nullToDefault(str, "");
    }

    public static String nullToDefault(CharSequence str, String defaultStr) {
        return str == null ? defaultStr : str.toString();
    }

    public static String emptyToDefault(CharSequence str, String defaultStr) {
        return StringKit.isEmpty(str) ? defaultStr : str.toString();
    }

    public static String blankToDefault(CharSequence str, String defaultStr) {
        return StringKit.isBlank(str) ? defaultStr : str.toString();
    }

    public static String emptyToNull(CharSequence str) {
        return StringKit.isEmpty(str) ? null : str.toString();
    }

    public static boolean isNullOrUndefined(CharSequence str) {
        if (null == str) {
            return true;
        }
        return StringKit.isNullOrUndefinedStr(str);
    }

    public static boolean isEmptyOrUndefined(CharSequence str) {
        if (StringKit.isEmpty(str)) {
            return true;
        }
        return StringKit.isNullOrUndefinedStr(str);
    }

    public static boolean isBlankOrUndefined(CharSequence str) {
        if (StringKit.isBlank(str)) {
            return true;
        }
        return StringKit.isNullOrUndefinedStr(str);
    }

    private static boolean isNullOrUndefinedStr(CharSequence str) {
        String strString = str.toString().trim();
        return "null".equals(strString) || "undefined".equals(strString);
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (values != null && values.length != 0) {
            String[] var2 = values;
            int var3 = values.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                String value = var2[var4];
                result &= !StringKit.isEmpty(value);
            }
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static String toString(Object obj) {
        return StringKit.toString(obj, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static String toString(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String toString(Object obj, String charset) {
        return StringKit.toString(obj, Charset.forName(charset));
    }

    public static String toString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String toString(Object obj, Charset charset) {
        if (ObjectKit.isEmpty(obj)) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StringKit.toString((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StringKit.toString((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StringKit.toString((ByteBuffer)obj, charset);
        }
        if (ArrayKit.isArray(obj)) {
            return ArrayKit.toString(obj);
        }
        return obj.toString();
    }

    public static String toString(byte[] bytes, String charset) {
        return StringKit.toString(bytes, StringKit.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String toString(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String toString(Byte[] bytes, String charset) {
        return StringKit.toString(bytes, StringKit.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String toString(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StringKit.toString(bytes, charset);
    }

    public static String toString(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StringKit.toString(data, Charset.forName(charset));
    }

    public static String toString(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String toString(String[] values) {
        if (ArrayKit.isEmpty(values)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            builder.append("," + value);
        }
        String parameter = builder.toString().trim();
        if (parameter.length() > 0) {
            return parameter.substring(1);
        }
        return "";
    }

    public static String toString(Class<?>[] parameterTypes) {
        if (ArrayKit.isEmpty(parameterTypes)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Class<?> clazz : parameterTypes) {
            builder.append("," + clazz.getCanonicalName());
        }
        String parameter = builder.toString().trim();
        if (parameter.length() > 0) {
            return parameter.substring(1);
        }
        return "";
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection.toArray(Normal.EMPTY_STRING_ARRAY);
    }

    public static String[] toStringArray(Enumeration<String> enumeration) {
        return StringKit.toStringArray(Collections.list(enumeration));
    }

    public static boolean hasText(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    public static byte[] base64ToByte(String str) {
        try {
            if (str == null) {
                return null;
            }
            return Base64.getDecoder().decode(str);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String base64ToString(String str) {
        try {
            if (str == null) {
                return null;
            }
            return new String(StringKit.base64ToByte(str), org.aoju.bus.core.lang.Charset.UTF_8);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String base64ToString(String str, String charset) {
        try {
            if (str == null) {
                return null;
            }
            return new String(StringKit.base64ToByte(str), charset);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String byteArrayToHex(byte[] byteArray) {
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = Normal.DIGITS_16_LOWER[b >>> 4 & 0xF];
            resultCharArray[index++] = Normal.DIGITS_16_LOWER[b & 0xF];
        }
        return new String(resultCharArray);
    }

    public static byte[] hexStringToByte(String hex) {
        if (StringKit.isEmpty(hex)) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length() / 2; ++i) {
            String subStr = hex.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)Integer.parseInt(subStr, 16);
        }
        return bytes;
    }

    public static String toUnicode(String input) {
        StringBuilder unicode = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            String hexStr = Integer.toHexString(c);
            while (hexStr.length() < 4) {
                hexStr = "0" + hexStr;
            }
            unicode.append("\\u" + hexStr);
        }
        return unicode.toString();
    }

    public static String toUnicode(String str, boolean isSkipAscii) {
        if (StringKit.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        TextKit unicode = TextKit.create(str.length() * 6);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (isSkipAscii && CharKit.isAsciiPrintable(c)) {
                unicode.append(c);
                continue;
            }
            unicode.append(HexKit.toUnicodeHex(c));
        }
        return unicode.toString();
    }

    public static String toUnicodeString(String input) {
        StringBuilder string = new StringBuilder();
        String[] hex = input.split("\\\\u");
        for (int i = 1; i < hex.length; ++i) {
            int data = Integer.parseInt(hex[i], 16);
            string.append((char)data);
        }
        return string.toString();
    }

    public static String toUnicodeString(String unicode, boolean isSkipAscii) {
        if (StringKit.isBlank(unicode)) {
            return unicode;
        }
        if (isSkipAscii) {
            int len = unicode.length();
            TextKit sb = TextKit.create(len);
            int i = -1;
            int pos = 0;
            while ((i = StringKit.indexOfIgnoreCase(unicode, "\\u", pos)) != -1) {
                sb.append(unicode, pos, i);
                pos = i;
                if (i + 5 < len) {
                    char c = '\u0000';
                    try {
                        c = (char)Integer.parseInt(unicode.substring(i + 2, i + 6), 16);
                        sb.append(c);
                        pos = i + 6;
                    }
                    catch (NumberFormatException e) {
                        sb.append(unicode, pos, i + 2);
                        pos = i + 2;
                    }
                    continue;
                }
                pos = i;
                break;
            }
            if (pos < len) {
                sb.append(unicode, pos, len);
            }
            return sb.toString();
        }
        return StringKit.toUnicodeString(unicode);
    }

    public static boolean equals(CharSequence stra, CharSequence strb) {
        return StringKit.equals(stra, strb, false);
    }

    public static boolean equals(CharSequence stra, CharSequence strb, boolean ignoreCase) {
        if (null == stra) {
            return strb == null;
        }
        if (null == strb) {
            return false;
        }
        if (ignoreCase) {
            return stra.toString().equalsIgnoreCase(strb.toString());
        }
        return stra.equals(strb);
    }

    public static boolean equalsIgnoreCase(CharSequence stra, CharSequence strb) {
        return StringKit.equals(stra, strb, true);
    }

    public static boolean equalsAnyIgnoreCase(CharSequence stra, CharSequence ... strb) {
        return StringKit.equalsAny(stra, true, strb);
    }

    public static boolean equalsAny(CharSequence str1, CharSequence ... strs) {
        return StringKit.equalsAny(str1, false, strs);
    }

    public static boolean equalsAny(CharSequence str1, boolean ignoreCase, CharSequence ... strs) {
        if (ArrayKit.isEmpty(strs)) {
            return false;
        }
        for (CharSequence str : strs) {
            if (!StringKit.equals(str1, str, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return "null";
        }
        if (ArrayKit.isEmpty(params) || StringKit.isBlank(template)) {
            return template.toString();
        }
        return StringKit.format(template.toString(), params);
    }

    public static String format(CharSequence template, Map<?, ?> map) {
        return StringKit.format(template, map, true);
    }

    public static String format(CharSequence template, Map<?, ?> map, boolean ignoreNull) {
        if (null == template) {
            return null;
        }
        if (null == map || map.isEmpty()) {
            return template.toString();
        }
        String template2 = template.toString();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String value = StringKit.toString(entry.getValue());
            if (null == value && ignoreNull) continue;
            template2 = StringKit.replace(template2, "{" + entry.getKey() + "}", value);
        }
        return template2;
    }

    public static String format(String val, Object ... argArray) {
        if (StringKit.isBlank(val) || ArrayKit.isEmpty(argArray)) {
            return val;
        }
        int strPatternLength = val.length();
        StringBuilder sbuf = new StringBuilder(strPatternLength + 50);
        int handledPosition = 0;
        for (int argIndex = 0; argIndex < argArray.length; ++argIndex) {
            int delimIndex = val.indexOf("{}", handledPosition);
            if (delimIndex == -1) {
                if (handledPosition == 0) {
                    return val;
                }
                sbuf.append(val, handledPosition, strPatternLength);
                return sbuf.toString();
            }
            if (delimIndex > 0 && val.charAt(delimIndex - 1) == '\\') {
                if (delimIndex > 1 && val.charAt(delimIndex - 2) == '\\') {
                    sbuf.append(val, handledPosition, delimIndex - 1);
                    sbuf.append(StringKit.toString(argArray[argIndex]));
                    handledPosition = delimIndex + 2;
                    continue;
                }
                --argIndex;
                sbuf.append(val, handledPosition, delimIndex - 1);
                sbuf.append('{');
                handledPosition = delimIndex + 1;
                continue;
            }
            sbuf.append(val, handledPosition, delimIndex);
            sbuf.append(StringKit.toString(argArray[argIndex]));
            handledPosition = delimIndex + 2;
        }
        sbuf.append(val, handledPosition, val.length());
        return sbuf.toString();
    }

    public static String sub(CharSequence str, int fromIndex, int toIndex) {
        if (StringKit.isEmpty(str)) {
            return StringKit.toString(str);
        }
        int len = str.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return "";
        }
        return str.toString().substring(fromIndex, toIndex);
    }

    public static String subPre(CharSequence string, int toIndex) {
        return StringKit.sub(string, 0, toIndex);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (StringKit.isEmpty(string)) {
            return null;
        }
        return StringKit.sub(string, fromIndex, string.length());
    }

    public static String subBeforeLast(String str, String separator) {
        if (StringKit.isEmpty(str) || StringKit.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String subAfterLast(String str, String separator) {
        if (StringKit.isEmpty(str)) {
            return str;
        }
        if (StringKit.isEmpty(separator)) {
            return "";
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String subCodePoint(CharSequence str, int fromIndex, int toIndex) {
        if (StringKit.isEmpty(str)) {
            return StringKit.toString(str);
        }
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int subLen = toIndex - fromIndex;
        str.toString().codePoints().skip(fromIndex).limit(subLen).forEach(v -> sb.append(Character.toChars(v)));
        return sb.toString();
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StringKit.isEmpty(string) || separator == null) {
            return null == string ? null : "";
        }
        String str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return "";
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (StringKit.isEmpty(string)) {
            return null == string ? null : "";
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StringKit.isEmpty(string)) {
            return null == string ? null : "";
        }
        if (separator == null) {
            return "";
        }
        String str = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos || string.length() - 1 == pos) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (StringKit.isEmpty(string)) {
            return null == string ? null : "";
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return "";
        }
        return str.substring(pos + 1);
    }

    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        return StringKit.subBetween(str.toString(), before.toString(), after.toString());
    }

    public static String subBetween(String str, String before, String after) {
        int end;
        if (str == null || before == null || after == null) {
            return null;
        }
        int start = str.indexOf(before);
        if (start != -1 && (end = str.indexOf(after, start + before.length())) != -1) {
            return str.substring(start + before.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence str, CharSequence beforeAndAfter) {
        return StringKit.subBetween(str, beforeAndAfter, beforeAndAfter);
    }

    public static String[] subBetweenAll(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StringKit.hasEmpty(str, prefix, suffix) || !StringKit.contains(str, prefix)) {
            return new String[0];
        }
        LinkedList<String> result = new LinkedList<String>();
        String[] split = StringKit.split(str, prefix);
        if (prefix.equals(suffix)) {
            int length = split.length - 1;
            for (int i = 1; i < length; i += 2) {
                result.add(split[i]);
            }
        } else {
            for (String fragment : split) {
                int suffixIndex = fragment.indexOf(suffix.toString());
                if (suffixIndex <= 0) continue;
                result.add(fragment.substring(0, suffixIndex));
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] subBetweenAll(CharSequence str, CharSequence prefixAndSuffix) {
        return StringKit.subBetweenAll(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static String subByLength(CharSequence string, int length) {
        if (StringKit.isEmpty(string)) {
            return null;
        }
        if (length <= 0) {
            return "";
        }
        return StringKit.sub(string, -length, string.length());
    }

    public static String subWithLength(String input, int fromIndex, int length) {
        return StringKit.sub(input, fromIndex, fromIndex + length);
    }

    public static List<String> splitPath(String str) {
        return StringKit.splitPath(str, 0);
    }

    public static List<String> splitPath(String str, int limit) {
        return StringKit.split(str, '/', limit, true, true);
    }

    public static String[] splitPathToArray(String str) {
        return ArrayKit.toArray(StringKit.splitPath(str));
    }

    public static String[] splitPathToArray(String str, int limit) {
        return ArrayKit.toArray(StringKit.splitPath(str, limit));
    }

    public static List<String> splitTrim(CharSequence str, char separator) {
        return StringKit.splitTrim(str.toString(), separator, true);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator) {
        return StringKit.splitTrim(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator, int limit) {
        return StringKit.split(str, separator, limit, true, true);
    }

    public static List<String> splitTrim(String str, char separator, boolean ignoreEmpty) {
        return StringKit.split(str, separator, 0, true, ignoreEmpty);
    }

    public static List<String> splitTrim(String str, String separator, boolean ignoreEmpty) {
        return StringKit.split(str, separator, true, ignoreEmpty);
    }

    public static List<String> splitTrim(String str, char separator, int limit, boolean ignoreEmpty) {
        return StringKit.split(str, separator, limit, true, ignoreEmpty, false);
    }

    public static List<String> splitTrim(String str, String separator, int limit, boolean ignoreEmpty) {
        return StringKit.split(str, separator, limit, true, ignoreEmpty);
    }

    public static List<String> splitIgnoreCase(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringKit.split(str, separator, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> splitIgnoreCase(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringKit.split(str, separator, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> splitTrimIgnoreCase(String str, String separator, int limit, boolean ignoreEmpty) {
        return StringKit.split(str, separator, limit, true, ignoreEmpty, true);
    }

    public static long[] splitToLong(CharSequence str, char separator) {
        return Convert.convert(long[].class, StringKit.splitTrim(str, separator));
    }

    public static long[] splitToLong(CharSequence str, CharSequence separator) {
        return Convert.convert(long[].class, StringKit.splitTrim(str, separator));
    }

    public static int[] splitToInt(CharSequence str, char separator) {
        return Convert.convert(int[].class, StringKit.splitTrim(str, separator));
    }

    public static int[] splitToInt(CharSequence str, CharSequence separator) {
        return Convert.convert(int[].class, StringKit.splitTrim(str, separator));
    }

    public static String[] splitToArray(CharSequence str, char separator, int limit) {
        if (null == str) {
            return new String[0];
        }
        return StringKit.splitToArray(str.toString(), separator, limit, false, false);
    }

    public static String[] splitToArray(String str, int limit) {
        return ArrayKit.toArray(StringKit.split(str, limit));
    }

    public static String[] splitToArray(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return ArrayKit.toArray(StringKit.split(str, separator, limit, isTrim, ignoreEmpty));
    }

    public static String[] splitToArray(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return ArrayKit.toArray(StringKit.split(str, separator, limit, isTrim, ignoreEmpty));
    }

    public static String[] splitToArray(String str, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        return ArrayKit.toArray(StringKit.split(str, separatorPattern, limit, isTrim, ignoreEmpty));
    }

    public static List<String> splitByRegex(String str, String separatorRegex, int limit, boolean isTrim, boolean ignoreEmpty) {
        Pattern pattern = PatternKit.get(separatorRegex);
        return StringKit.split(str, pattern, limit, isTrim, ignoreEmpty);
    }

    public static String[] splitByLength(String text, int len) {
        int partCount = text.length() / len;
        int lastPartCount = text.length() % len;
        int fixPart = 0;
        if (lastPartCount != 0) {
            fixPart = 1;
        }
        String[] strs = new String[partCount + fixPart];
        for (int i = 0; i < partCount + fixPart; ++i) {
            strs[i] = i == partCount + fixPart - 1 && lastPartCount != 0 ? text.substring(i * len, i * len + lastPartCount) : text.substring(i * len, i * len + len);
        }
        return strs;
    }

    public static String split(String str) {
        return StringKit.split(str, ",", ",");
    }

    public static String[] split(CharSequence str, CharSequence separator) {
        if (str == null) {
            return new String[0];
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StringKit.splitToArray(str.toString(), separatorStr, 0, false, false);
    }

    public static String split(String str, CharSequence separator, CharSequence reserve) {
        StringBuffer sb = new StringBuffer();
        if (StringKit.isNotEmpty(str)) {
            String[] arr = StringKit.split((CharSequence)str, separator);
            for (int i = 0; i < arr.length; ++i) {
                if (i == 0) {
                    sb.append("'").append(arr[i]).append("'");
                    continue;
                }
                sb.append(reserve).append("'").append(arr[i]).append("'");
            }
        }
        return sb.toString();
    }

    public static List<String> split(String str, char separator) {
        return StringKit.split((CharSequence)str, separator, -1);
    }

    public static List<String> split(CharSequence str, char separator) {
        return StringKit.split(str, separator, 0);
    }

    public static List<String> split(String str, int limit) {
        if (StringKit.isEmpty(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return CollKit.addAll(new ArrayList<String>(1), str, true, true);
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (!CharKit.isBlankChar(str.charAt(i))) continue;
            CollKit.addAll(list, str.substring(start, i), true, true);
            start = i + 1;
            if (limit > 0 && list.size() > limit - 2) break;
        }
        return CollKit.addAll(list, str.substring(start, len), true, true);
    }

    public static List<String> split(CharSequence str, char separator, int limit) {
        return StringKit.split(str.toString(), separator, limit, false, false);
    }

    public static List<String> split(String str, char separator, boolean isTrim, boolean ignoreEmpty) {
        return StringKit.split(str, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(String str, String separator, boolean isTrim, boolean ignoreEmpty) {
        return StringKit.split(str, separator, -1, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence str, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str) {
            return new ArrayList<String>(0);
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StringKit.split(str.toString(), separatorStr, limit, isTrim, ignoreEmpty);
    }

    public static List<String> split(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringKit.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringKit.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str) {
            return new ArrayList<String>(0);
        }
        return StringKit.split(str.toString(), separator, limit, isTrim, ignoreEmpty);
    }

    public static List<String> split(String str, Pattern separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (StringKit.isEmpty(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return CollKit.addAll(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        if (null == separator) {
            return StringKit.split(str, limit);
        }
        Matcher matcher = separator.matcher(str);
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int start = 0;
        while (matcher.find()) {
            CollKit.addAll(list, str.substring(start, matcher.start()), isTrim, ignoreEmpty);
            start = matcher.end();
            if (limit <= 0 || list.size() <= limit - 2) continue;
            break;
        }
        return CollKit.addAll(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static List<String> split(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (StringKit.isEmpty(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return CollKit.addAll(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        ArrayList<String> list = new ArrayList<String>(limit > 0 ? limit : 16);
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (!MathKit.equals(separator, str.charAt(i), ignoreCase)) continue;
            CollKit.addAll(list, str.substring(start, i), isTrim, ignoreEmpty);
            start = i + 1;
            if (limit > 0 && list.size() > limit - 2) break;
        }
        return CollKit.addAll(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static List<String> split(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (StringKit.isEmpty(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return CollKit.addAll(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        if (StringKit.isEmpty(separator)) {
            return StringKit.split(str, limit);
        }
        if (separator.length() == 1) {
            return StringKit.split(str, separator.charAt(0), limit, isTrim, ignoreEmpty, ignoreCase);
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int separatorLen = separator.length();
        int start = 0;
        int i = 0;
        while (i < len && (i = StringKit.indexOf((CharSequence)str, separator, start, ignoreCase)) > -1) {
            CollKit.addAll(list, str.substring(start, i), isTrim, ignoreEmpty);
            start = i + separatorLen;
            if (limit <= 0 || list.size() <= limit - 2) continue;
            break;
        }
        return CollKit.addAll(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return StringKit.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return StringKit.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence str, char searchChar, int start, int end) {
        if (StringKit.isEmpty(str)) {
            return 94;
        }
        int len = str.length();
        if (start < 0 || start > len) {
            start = 0;
        }
        if (end > len || end < 0) {
            end = len;
        }
        for (int i = start; i < end; ++i) {
            if (str.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringKit.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringKit.indexOf(str, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().indexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i < endLimit; ++i) {
            if (!StringKit.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringKit.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringKit.lastIndexOf(str, searchStr, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        fromIndex = Math.min(fromIndex, str.length());
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().lastIndexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!StringKit.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int ordinalIndexOf(String str, String searchStr, int ordinal) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = str.indexOf(searchStr, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return "";
        }
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(CharSequence str, int count) {
        int n;
        if (null == str) {
            return null;
        }
        if (count <= 0 || str.length() == 0) {
            return "";
        }
        if (count == 1) {
            return str.toString();
        }
        int len = str.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        str.toString().getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static String repeatByLength(CharSequence str, int padLen) {
        if (null == str) {
            return null;
        }
        if (padLen <= 0) {
            return "";
        }
        int strLen = str.length();
        if (strLen == padLen) {
            return str.toString();
        }
        if (strLen > padLen) {
            return StringKit.subPre(str, padLen);
        }
        char[] padding = new char[padLen];
        for (int i = 0; i < padLen; ++i) {
            padding[i] = str.charAt(i % strLen);
        }
        return new String(padding);
    }

    public static String repeatAndJoin(CharSequence str, int count, CharSequence conjunction) {
        if (count <= 0) {
            return "";
        }
        Builders builder = Builders.create();
        boolean isFirst = true;
        while (count-- > 0) {
            if (isFirst) {
                isFirst = false;
            } else if (StringKit.isNotEmpty(conjunction.toString())) {
                builder.append(conjunction);
            }
            builder.append(str);
        }
        return builder.toString();
    }

    public static String reverse(String str) {
        char[] chars = str.toCharArray();
        ArrayKit.reverse(chars);
        return new String(chars);
    }

    public static byte[] bytes(CharSequence str) {
        return StringKit.bytes(str, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence str, String charset) {
        return StringKit.bytes(str, StringKit.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static String removeStart(String str, String remove) {
        if (StringKit.isEmpty(str) || StringKit.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removePreAndLowerFirst(CharSequence str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str.toString();
    }

    public static String removePreAndLowerFirst(CharSequence str, CharSequence prefix) {
        return StringKit.lowerFirst(StringKit.removePrefix(str, prefix));
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        if (StringKit.isEmpty(str) || StringKit.isEmpty(prefix)) {
            return StringKit.toString(str);
        }
        String str2 = str.toString();
        if (str2.startsWith(prefix.toString())) {
            return StringKit.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removePrefixIgnoreCase(CharSequence str, CharSequence prefix) {
        if (StringKit.isEmpty(str) || StringKit.isEmpty(prefix)) {
            return StringKit.toString(str);
        }
        String str2 = str.toString();
        if (str2.toLowerCase().startsWith(prefix.toString().toLowerCase())) {
            return StringKit.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (StringKit.isEmpty(str) || StringKit.isEmpty(suffix)) {
            return StringKit.toString(str);
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return StringKit.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String upperFirstAndAddPre(CharSequence str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + StringKit.upperFirst(str);
    }

    public static String upperFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isLowerCase(firstChar = str.charAt(0))) {
            return Character.toUpperCase(firstChar) + StringKit.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String lowerFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isUpperCase(firstChar = str.charAt(0))) {
            return Character.toLowerCase(firstChar) + StringKit.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String toUnderlineCase(CharSequence camelCaseStr) {
        if (camelCaseStr == null) {
            return null;
        }
        int length = camelCaseStr.length();
        StringBuilder sb = new StringBuilder();
        boolean isPreUpperCase = false;
        for (int i = 0; i < length; ++i) {
            char c = camelCaseStr.charAt(i);
            boolean isNextUpperCase = true;
            if (i < length - 1) {
                isNextUpperCase = Character.isUpperCase(camelCaseStr.charAt(i + 1));
            }
            if (Character.isUpperCase(c)) {
                if (!(isPreUpperCase && isNextUpperCase || i <= 0)) {
                    sb.append("_");
                }
                isPreUpperCase = true;
            } else {
                isPreUpperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String toSymbolCase(CharSequence str, char symbol) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        Builders sb = new Builders();
        for (int i = 0; i < length; ++i) {
            Character preChar;
            char c = str.charAt(i);
            Character c2 = preChar = i > 0 ? Character.valueOf(str.charAt(i - 1)) : null;
            if (Character.isUpperCase(c)) {
                Character nextChar;
                Character c3 = nextChar = i < str.length() - 1 ? Character.valueOf(str.charAt(i + 1)) : null;
                if (null != preChar && Character.isUpperCase(preChar.charValue())) {
                    sb.append(c);
                    continue;
                }
                if (null != nextChar && !Character.isLowerCase(nextChar.charValue())) {
                    if (null != preChar && symbol != preChar.charValue()) {
                        sb.append(symbol);
                    }
                    sb.append(c);
                    continue;
                }
                if (null != preChar && symbol != preChar.charValue()) {
                    sb.append(symbol);
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (symbol != c && sb.length() > 0 && Character.isUpperCase(sb.charAt(-1)) && Character.isLowerCase(c)) {
                sb.append(symbol);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCamelCase(CharSequence name) {
        if (null == name) {
            return null;
        }
        String name2 = name.toString();
        if (name2.contains("_")) {
            StringBuilder sb = new StringBuilder(name2.length());
            boolean upperCase = false;
            for (int i = 0; i < name2.length(); ++i) {
                char c = name2.charAt(i);
                if (c == '_') {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(Character.toLowerCase(c));
            }
            return sb.toString();
        }
        return name2;
    }

    public static String remove(String str, String remove) {
        if (StringKit.isEmpty(str) || StringKit.isEmpty(remove)) {
            return str;
        }
        return StringKit.replace(str, remove, "", -1);
    }

    public static String removeIgnoreCase(String str, String remove) {
        if (StringKit.isEmpty(str) || StringKit.isEmpty(remove)) {
            return str;
        }
        return StringKit.replaceIgnoreCase(str, remove, "", -1);
    }

    public static String remove(String str, char remove) {
        if (StringKit.isEmpty(str) || str.indexOf(remove) == -1) {
            return str;
        }
        char[] chars = str.toCharArray();
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == remove) continue;
            chars[pos++] = chars[i];
        }
        return new String(chars, 0, pos);
    }

    public static String removeAll(String text, String regex) {
        return StringKit.replaceAll(text, regex, "");
    }

    public static String removeAll(CharSequence str, char ... chars) {
        if (null == str || ArrayKit.isEmpty(chars)) {
            return StringKit.toString(str);
        }
        int len = str.length();
        if (0 == len) {
            return StringKit.toString(str);
        }
        StringBuilder builder = StringKit.builder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (ArrayKit.contains(chars, c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String removeAll(CharSequence str, CharSequence strToRemove) {
        if (StringKit.isEmpty(str) || StringKit.isEmpty(strToRemove)) {
            return StringKit.toString(str);
        }
        return str.toString().replace(strToRemove, "");
    }

    public static String removeAny(CharSequence str, CharSequence ... strsToRemove) {
        String result = StringKit.toString(str);
        if (StringKit.isNotEmpty(str)) {
            for (CharSequence strToRemove : strsToRemove) {
                result = StringKit.removeAll((CharSequence)result, strToRemove);
            }
        }
        return result;
    }

    public static String removeFirst(String text, String regex) {
        return StringKit.replaceFirst(text, regex, "");
    }

    public static String replaceAll(String text, String regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return text.replaceAll(regex, replacement);
    }

    public static String replaceFirst(String text, String regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return text.replaceFirst(regex, replacement);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringKit.replace(text, searchString, replacement, -1);
    }

    public static String replaceIgnoreCase(String text, String searchString, String replacement) {
        return StringKit.replaceIgnoreCase(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        return StringKit.replace(text, searchString, replacement, max, false);
    }

    private static String replace(String text, String searchString, String replacement, int max, boolean ignoreCase) {
        int start;
        int end;
        if (StringKit.isEmpty(text) || StringKit.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        String searchText = text;
        if (ignoreCase) {
            searchText = text.toLowerCase();
            searchString = searchString.toLowerCase();
        }
        if ((end = searchText.indexOf(searchString, start = 0)) == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = searchText.indexOf(searchString, start);
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }

    public static String replaceBlank(String str) {
        String val = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            val = m.replaceAll("");
        }
        return val;
    }

    public static String replaceIgnoreCase(String text, String searchString, String replacement, int max) {
        return StringKit.replace(text, searchString, replacement, max, true);
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        return StringKit.replaceEach(text, searchList, replacementList, false, 0);
    }

    public static String replaceEachRepeatedly(String text, String[] searchList, String[] replacementList) {
        int timeToLive = searchList == null ? 0 : searchList.length;
        return StringKit.replaceEach(text, searchList, replacementList, true, timeToLive);
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList, boolean repeat, int timeToLive) {
        if (text == null || text.isEmpty() || searchList == null || searchList.length == 0 || replacementList == null || replacementList.length == 0) {
            return text;
        }
        if (timeToLive < 0) {
            throw new IllegalStateException("Aborting to protect against StackOverflowError - output of one loop is the input of another");
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        int tempIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].isEmpty() || replacementList[i] == null) continue;
            tempIndex = text.indexOf(searchList[i]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i = 0; i < searchList.length; ++i) {
            int greater;
            if (searchList[i] == null || replacementList[i] == null || (greater = replacementList[i].length() - searchList[i].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].isEmpty() || replacementList[i] == null) continue;
                tempIndex = text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        String result = buf.toString();
        if (!repeat) {
            return result;
        }
        return StringKit.replaceEach(result, searchList, replacementList, repeat, timeToLive - 1);
    }

    public static String replaceChars(String str, char searchChar, char replaceChar) {
        if (str == null) {
            return null;
        }
        return str.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        if (StringKit.isEmpty(str) || StringKit.isEmpty(searchChars)) {
            return str;
        }
        if (replaceChars == null) {
            replaceChars = "";
        }
        boolean modified = false;
        int replaceCharsLength = replaceChars.length();
        int strLength = str.length();
        StringBuilder buf = new StringBuilder(strLength);
        for (int i = 0; i < strLength; ++i) {
            char ch = str.charAt(i);
            int index = searchChars.indexOf(ch);
            if (index >= 0) {
                modified = true;
                if (index >= replaceCharsLength) continue;
                buf.append(replaceChars.charAt(index));
                continue;
            }
            buf.append(ch);
        }
        if (modified) {
            return buf.toString();
        }
        return str;
    }

    public static String replaceIgnoreCase(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return StringKit.replace(str, 0, searchStr, replacement, true);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return StringKit.replace(str, 0, searchStr, replacement, false);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        return StringKit.replace(str, 0, searchStr, replacement, ignoreCase);
    }

    public static String replace(CharSequence str, int fromIndex, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        if (StringKit.isEmpty(str) || StringKit.isEmpty(searchStr)) {
            return StringKit.toString(str);
        }
        if (null == replacement) {
            replacement = "";
        }
        int strLength = str.length();
        int searchStrLength = searchStr.length();
        if (fromIndex > strLength) {
            return StringKit.toString(str);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        TextKit result = TextKit.create(strLength + 16);
        if (0 != fromIndex) {
            result.append(str.subSequence(0, fromIndex));
        }
        int preIndex = fromIndex;
        int index = fromIndex;
        while ((index = StringKit.indexOf(str, searchStr, preIndex, ignoreCase)) > -1) {
            result.append(str.subSequence(preIndex, index));
            result.append(replacement);
            preIndex = index + searchStrLength;
        }
        if (preIndex < strLength) {
            result.append(str.subSequence(preIndex, strLength));
        }
        return result.toString();
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (StringKit.isEmpty(str)) {
            return StringKit.toString(str);
        }
        int strLength = str.length();
        if (startInclude > strLength) {
            return StringKit.toString(str);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return StringKit.toString(str);
        }
        char[] chars = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars[i] = i >= startInclude && i < endExclude ? replacedChar : str.charAt(i);
        }
        return new String(chars);
    }

    public static String hide(CharSequence str, int startInclude, int endExclude) {
        return StringKit.replace(str, startInclude, endExclude, '*');
    }

    public static String replaceChars(CharSequence str, String chars, CharSequence replacedStr) {
        if (StringKit.isEmpty(str) || StringKit.isEmpty(chars)) {
            return StringKit.toString(str);
        }
        return StringKit.replaceChars(str, chars.toCharArray(), replacedStr);
    }

    public static String replaceChars(CharSequence str, char[] chars, CharSequence replacedStr) {
        if (StringKit.isEmpty(str) || ArrayKit.isEmpty(chars)) {
            return StringKit.toString(str);
        }
        HashSet<Character> set = new HashSet<Character>(chars.length);
        for (char c : chars) {
            set.add(Character.valueOf(c));
        }
        int strLen = str.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            builder.append(set.contains(Character.valueOf(c)) ? replacedStr : Character.valueOf(c));
        }
        return builder.toString();
    }

    public static String cleanBlank(CharSequence str) {
        return StringKit.filter(str, c -> !CharKit.isBlankChar(c.charValue()));
    }

    public static String wrap(CharSequence str, CharSequence prefixAndSuffix) {
        return StringKit.wrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static String wrap(CharSequence str, CharSequence prefix, CharSequence suffix) {
        return StringKit.nullToEmpty(prefix).concat(StringKit.nullToEmpty(str)).concat(StringKit.nullToEmpty(suffix));
    }

    public static String[] wrapAll(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return StringKit.wrapAll(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAll(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = StringKit.wrap(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String unWrap(CharSequence str, String prefix, String suffix) {
        if (StringKit.isWrap(str, prefix, suffix)) {
            return StringKit.sub(str, prefix.length(), str.length() - suffix.length());
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefix, char suffix) {
        if (StringKit.isEmpty(str)) {
            return StringKit.toString(str);
        }
        if (str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix) {
            return StringKit.sub(str, 1, str.length() - 1);
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefixAndSuffix) {
        return StringKit.unWrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static boolean isWrap(CharSequence str, String prefix, String suffix) {
        if (ArrayKit.hasNull(str, prefix, suffix)) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix) && str2.endsWith(suffix);
    }

    public static boolean isWrap(CharSequence str, String wrapper) {
        return StringKit.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char wrapper) {
        return StringKit.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char prefixChar, char suffixChar) {
        if (null == str) {
            return false;
        }
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public static String wrapIfMissing(CharSequence str, CharSequence prefix, CharSequence suffix) {
        int len = 0;
        if (StringKit.isNotEmpty(str)) {
            len += str.length();
        }
        if (StringKit.isNotEmpty(prefix)) {
            len += str.length();
        }
        if (StringKit.isNotEmpty(suffix)) {
            len += str.length();
        }
        StringBuilder sb = new StringBuilder(len);
        if (StringKit.isNotEmpty(prefix) && !StringKit.startWith(str, prefix)) {
            sb.append(prefix);
        }
        if (StringKit.isNotEmpty(str)) {
            sb.append(str);
        }
        if (StringKit.isNotEmpty(suffix) && !StringKit.endWith(str, suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String[] wrapAllIfMissing(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return StringKit.wrapAllIfMissing(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAllIfMissing(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = StringKit.wrapIfMissing(strs[i], prefix, suffix);
        }
        return results;
    }

    public static boolean startWith(CharSequence str, char c) {
        if (StringKit.isEmpty(str)) {
            return false;
        }
        return c == str.charAt(0);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        return StringKit.startWith(str, prefix, ignoreCase, false);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        if (null == str || null == prefix) {
            if (!ignoreEquals) {
                return false;
            }
            return null == str && null == prefix;
        }
        boolean isStartWith = ignoreCase ? str.toString().toLowerCase().startsWith(prefix.toString().toLowerCase()) : str.toString().startsWith(prefix.toString());
        if (isStartWith) {
            return false == ignoreEquals || false == StringKit.equals(str, prefix, ignoreCase);
        }
        return false;
    }

    public static boolean startWith(CharSequence str, CharSequence prefix) {
        return StringKit.startWith(str, prefix, false);
    }

    public static boolean startWithIgnoreEquals(CharSequence str, CharSequence prefix) {
        return StringKit.startWith(str, prefix, false, true);
    }

    public static boolean startWithAny(CharSequence str, CharSequence ... prefixes) {
        if (StringKit.isEmpty(str) || ArrayKit.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence suffix : prefixes) {
            if (!StringKit.startWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return StringKit.startWith(str, prefix, true);
    }

    public static boolean endWith(CharSequence str, char c) {
        if (StringKit.isEmpty(str)) {
            return false;
        }
        return c == str.charAt(str.length() - 1);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean isIgnoreCase) {
        if (null == str || null == suffix) {
            return null == str && null == suffix;
        }
        if (isIgnoreCase) {
            return str.toString().toLowerCase().endsWith(suffix.toString().toLowerCase());
        }
        return str.toString().endsWith(suffix.toString());
    }

    public static boolean endWith(CharSequence str, CharSequence suffix) {
        return StringKit.endWith(str, suffix, false);
    }

    public static boolean endWithAny(CharSequence str, CharSequence ... suffixes) {
        if (StringKit.isEmpty(str) || ArrayKit.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!StringKit.endWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return StringKit.endWith(str, suffix, true);
    }

    public static String strip(CharSequence str, CharSequence prefixOrSuffix) {
        return StringKit.strip(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String strip(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StringKit.isEmpty(str)) {
            return StringKit.toString(str);
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (StringKit.startWith((CharSequence)str2, prefix)) {
            from = prefix.length();
        }
        if (StringKit.endWith((CharSequence)str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(from, to);
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefixOrSuffix) {
        return StringKit.stripIgnoreCase(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StringKit.isEmpty(str)) {
            return StringKit.toString(str);
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (StringKit.startWithIgnoreCase(str2, prefix)) {
            from = prefix.length();
        }
        if (StringKit.endWithIgnoreCase(str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(from, to);
    }

    public static String addPrefixIfNot(CharSequence str, CharSequence prefix) {
        String prefix2;
        if (StringKit.isEmpty(str) || StringKit.isEmpty(prefix)) {
            return StringKit.toString(str);
        }
        String str2 = str.toString();
        if (!str2.startsWith(prefix2 = prefix.toString())) {
            return prefix2.concat(str2);
        }
        return str2;
    }

    public static String addSuffixIfNot(CharSequence str, CharSequence suffix) {
        String suffix2;
        if (StringKit.isEmpty(str) || StringKit.isEmpty(suffix)) {
            return StringKit.toString(str);
        }
        String str2 = str.toString();
        if (!str2.endsWith(suffix2 = suffix.toString())) {
            return str2.concat(suffix2);
        }
        return str2;
    }

    public static boolean contains(CharSequence str, char searchChar) {
        return StringKit.indexOf(str, searchChar) > -1;
    }

    public static boolean contains(CharSequence str, CharSequence searchStr) {
        if (null == str || null == searchStr) {
            return false;
        }
        return str.toString().contains(searchStr);
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != StringKit.getContainsAny(str, testStrs);
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (!StringKit.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayKit.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnly(CharSequence str, char ... testChars) {
        if (!StringKit.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (ArrayKit.contains(testChars, str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsBlank(CharSequence str) {
        if (null == str) {
            return false;
        }
        int length = str.length();
        if (0 == length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!CharKit.isBlankChar(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsAny(CharSequence str, CharSequence ... testStrs) {
        if (StringKit.isEmpty(str) || ArrayKit.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!str.toString().contains(checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toString().toLowerCase().contains(testStr.toString().toLowerCase());
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        return null != StringKit.getContainsStrIgnoreCase(str, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (StringKit.isEmpty(str) || ArrayKit.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence testStr : testStrs) {
            if (!StringKit.containsIgnoreCase(str, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static boolean isSurround(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StringKit.isBlank(str)) {
            return false;
        }
        if (str.length() < prefix.length() + suffix.length()) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix.toString()) && str2.endsWith(suffix.toString());
    }

    public static boolean isSurround(CharSequence str, char prefix, char suffix) {
        if (StringKit.isBlank(str)) {
            return false;
        }
        if (str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix;
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringKit.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringKit.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringKit.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(StringKit.repeat(padChar, pads));
    }

    public static String left(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String right(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static String mid(String str, int pos, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0 || pos > str.length()) {
            return "";
        }
        if (pos < 0) {
            pos = 0;
        }
        if (str.length() <= pos + len) {
            return str.substring(pos);
        }
        return str.substring(pos, pos + len);
    }

    public static String leftPad(String str, int size) {
        return StringKit.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringKit.leftPad(str, size, String.valueOf(padChar));
        }
        return StringKit.repeat(padChar, pads).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringKit.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringKit.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String buildString(Object original, String middle, int prefixLength) {
        if (ObjectKit.isNull(original)) {
            return null;
        }
        String string = original.toString();
        int stringLength = string.length();
        String prefix = stringLength >= prefixLength ? string.substring(0, prefixLength) : string.substring(0, stringLength);
        String suffix = "";
        int suffixLength = stringLength - prefix.length() - middle.length();
        if (suffixLength > 0) {
            suffix = string.substring(stringLength - suffixLength);
        }
        return prefix + middle + suffix;
    }

    public static String concat(boolean isNullToEmpty, CharSequence ... strs) {
        Builders sb = new Builders();
        for (CharSequence str : strs) {
            sb.append(isNullToEmpty ? StringKit.nullToEmpty(str) : str);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(CharSequence str) {
        if (null == str) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence str) {
        if (null == str) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int byteLength(CharSequence cs, Charset charset) {
        return cs == null ? 0 : cs.toString().getBytes(charset).length;
    }

    public static String swapCase(String str) {
        if (StringKit.isEmpty(str)) {
            return str;
        }
        char[] buffer = str.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isUpperCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (Character.isTitleCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        return new String(buffer);
    }

    public static String fillBefore(String str, char filledChar, int len) {
        return StringKit.fill(str, filledChar, len, true);
    }

    public static String fillAfter(String strVal, char charVal, int len) {
        return StringKit.fill(strVal, charVal, len, false);
    }

    public static String fill(String strVal, char charVal, int len, boolean isPre) {
        int strLen = strVal.length();
        if (strLen > len) {
            return strVal;
        }
        String filled = StringKit.repeat(charVal, len - strLen);
        return isPre ? filled.concat(strVal) : strVal.concat(filled);
    }

    public static String fill(int count, char charVal) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater than or equal 0.");
        }
        char[] chs = new char[count];
        for (int i = 0; i < count; ++i) {
            chs[i] = charVal;
        }
        return new String(chs);
    }

    public static String fill(int count, String strVal) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater than or equal 0.");
        }
        StringBuilder sb = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            sb.append(strVal);
        }
        return sb.toString();
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static Builders builders() {
        return new Builders();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static Builders builders(int capacity) {
        return new Builders(capacity);
    }

    public static StringBuilder builder(CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static Builders builders(CharSequence ... strs) {
        return new Builders(strs);
    }

    public static StringReader getReader(CharSequence str) {
        if (null == str) {
            return null;
        }
        return new StringReader(str.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (StringKit.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (StringKit.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String[] cut(CharSequence str, int partLength) {
        if (null == str) {
            return null;
        }
        int len = str.length();
        if (len < partLength) {
            return new String[]{str.toString()};
        }
        int part = MathKit.count(len, partLength);
        String[] array = new String[part];
        String str2 = str.toString();
        for (int i = 0; i < part; ++i) {
            array[i] = str2.substring(i * partLength, i == part - 1 ? len : partLength + i * partLength);
        }
        return array;
    }

    public static String brief(CharSequence str, int maxLength) {
        if (null == str) {
            return null;
        }
        if (str.length() <= maxLength) {
            return str.toString();
        }
        int w = maxLength / 2;
        int l = str.length() + 3;
        String str2 = str.toString();
        return StringKit.format("{}...{}", str2.substring(0, maxLength - w), str2.substring(l - w));
    }

    public static String firstCharToLower(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpper(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static String cleanText(String txt) {
        if (txt == null) {
            return null;
        }
        return Pattern.compile("[`'\"|/,;()-+*%#\u00b7\u2022\ufffd\u3000\\s]").matcher(txt).replaceAll("");
    }

    public static String cleanIdentifier(String param) {
        if (param == null) {
            return null;
        }
        StringBuilder paramBuilder = new StringBuilder();
        for (int i = 0; i < param.length(); ++i) {
            char c = param.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            paramBuilder.append(c);
        }
        return paramBuilder.toString();
    }

    public static String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String upperCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase(locale);
    }

    public static String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String lowerCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase(locale);
    }

    public static String capitalize(String str) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String uncapitalize(String str) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toLowerCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static boolean endsWithAny(CharSequence sequence, CharSequence ... searchStrings) {
        if (StringKit.isEmpty(sequence) || ArrayKit.isEmpty(searchStrings)) {
            return false;
        }
        for (CharSequence searchString : searchStrings) {
            if (!StringKit.endWith(sequence, searchString)) continue;
            return true;
        }
        return false;
    }

    private static String appendIfMissing(String str, CharSequence suffix, boolean ignoreCase, CharSequence ... suffixes) {
        if (str == null || StringKit.isEmpty(suffix) || StringKit.endWith(str, suffix, ignoreCase)) {
            return StringKit.toString(str);
        }
        if (suffixes != null && suffixes.length > 0) {
            for (CharSequence s : suffixes) {
                if (!StringKit.endWith(str, s, ignoreCase)) continue;
                return str;
            }
        }
        return str.concat(suffix.toString());
    }

    public static String appendIfMissing(String str, CharSequence suffix, CharSequence ... suffixes) {
        return StringKit.appendIfMissing(str, suffix, false, suffixes);
    }

    public static String appendIfMissingIgnoreCase(String str, CharSequence suffix, CharSequence ... suffixes) {
        return StringKit.appendIfMissing(str, suffix, true, suffixes);
    }

    private static String prependIfMissing(String str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (str == null || StringKit.isEmpty(prefix) || StringKit.startWith(str, prefix, ignoreCase)) {
            return StringKit.toString(str);
        }
        if (prefixes != null && prefixes.length > 0) {
            for (CharSequence s : prefixes) {
                if (!StringKit.startWith(str, s, ignoreCase)) continue;
                return str;
            }
        }
        return prefix.toString().concat(str);
    }

    public static String prependIfMissing(String str, CharSequence prefix, CharSequence ... prefixes) {
        return StringKit.prependIfMissing(str, prefix, false, prefixes);
    }

    public static String prependIfMissingIgnoreCase(String str, CharSequence prefix, CharSequence ... prefixes) {
        return StringKit.prependIfMissing(str, prefix, true, prefixes);
    }

    public static String maxLength(CharSequence string, int length) {
        Assert.isTrue(length > 0);
        if (null == string) {
            return null;
        }
        if (string.length() <= length) {
            return string.toString();
        }
        return StringKit.sub(string, 0, length) + "...";
    }

    public static String center(CharSequence str, int size) {
        return StringKit.center(str, size, ' ');
    }

    public static String center(CharSequence str, int size, char padChar) {
        if (str == null || size <= 0) {
            return StringKit.toString(str);
        }
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str.toString();
        }
        str = StringKit.padPre(str, strLen + pads / 2, padChar);
        str = StringKit.padAfter(str, size, padChar);
        return str.toString();
    }

    public static String center(CharSequence str, int size, CharSequence padStr) {
        int strLen;
        int pads;
        if (str == null || size <= 0) {
            return StringKit.toString(str);
        }
        if (StringKit.isEmpty(padStr)) {
            padStr = " ";
        }
        if ((pads = size - (strLen = str.length())) <= 0) {
            return str.toString();
        }
        str = StringKit.padPre(str, strLen + pads / 2, padStr);
        str = StringKit.padAfter(str, size, padStr);
        return str.toString();
    }

    public static String padPre(CharSequence str, int minLength, CharSequence padStr) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StringKit.subPre(str, minLength);
        }
        return StringKit.repeatByLength(padStr, minLength - strLen).concat(str.toString());
    }

    public static String padPre(CharSequence str, int minLength, char padChar) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StringKit.subPre(str, minLength);
        }
        return StringKit.repeat(padChar, minLength - strLen).concat(str.toString());
    }

    public static String padAfter(CharSequence str, int minLength, char padChar) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StringKit.sub(str, strLen - minLength, strLen);
        }
        return str.toString().concat(StringKit.repeat(padChar, minLength - strLen));
    }

    public static String padAfter(CharSequence str, int minLength, CharSequence padStr) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StringKit.subByLength(str, minLength);
        }
        return str.toString().concat(StringKit.repeatByLength(padStr, minLength - strLen));
    }

    public static boolean equalsCharAt(CharSequence str, int position, char c) {
        if (null == str || position < 0) {
            return false;
        }
        return str.length() > position && c == str.charAt(position);
    }

    public static String sort(String str) {
        if (StringKit.isEmpty(str) || "".equalsIgnoreCase(str)) {
            return null;
        }
        char[] strArray = str.toCharArray();
        Arrays.sort(strArray);
        return String.valueOf(strArray);
    }

    public static String filter(CharSequence str, Filter<Character> filter) {
        if (str == null || filter == null) {
            return StringKit.toString(str);
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!filter.accept(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static double similar(String str1, String str2) {
        return Similarity.similar(str1, str2);
    }

    public static String similar(String str1, String str2, int scale) {
        return Similarity.similar(str1, str2, scale);
    }

    public <T extends CharSequence> T firstNonNull(T ... strs) {
        return (T)((CharSequence)ArrayKit.firstNonNull(strs));
    }

    public <T extends CharSequence> T firstNonEmpty(T ... strs) {
        return (T)ArrayKit.firstNonNull(StringKit::isNotEmpty, strs);
    }

    public <T extends CharSequence> T firstNonBlank(T ... strs) {
        return (T)ArrayKit.firstNonNull(StringKit::isNotBlank, strs);
    }

    public CharSequence cover(String str, int start, int len, Character character) {
        if (start < 0 || len > str.length()) {
            throw new IndexOutOfBoundsException();
        }
        int end = start + len;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            sb.append(start <= i && i < end ? character.charValue() : str.charAt(i));
        }
        return sb;
    }
}

