/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.aoju.bus.core.io.streams.ByteArrayOutputStream;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Console;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class ZipKit {
    private static final int DEFAULT_BYTE_ARRAY_LENGTH = 32;
    private static final java.nio.charset.Charset DEFAULT_CHARSET = java.nio.charset.Charset.defaultCharset();

    public static File zip(String srcPath) throws InstrumentException {
        return ZipKit.zip(srcPath, DEFAULT_CHARSET);
    }

    public static File zip(String srcPath, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.zip(FileKit.file(srcPath), charset);
    }

    public static File zip(File srcFile) throws InstrumentException {
        return ZipKit.zip(srcFile, DEFAULT_CHARSET);
    }

    public static File zip(File srcFile, java.nio.charset.Charset charset) throws InstrumentException {
        File zipFile = FileKit.file(srcFile.getParentFile(), FileKit.mainName(srcFile) + ".zip");
        ZipKit.zip(zipFile, charset, false, srcFile);
        return zipFile;
    }

    public static File zip(String srcPath, String zipPath) throws InstrumentException {
        return ZipKit.zip(srcPath, zipPath, false);
    }

    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws InstrumentException {
        return ZipKit.zip(srcPath, zipPath, DEFAULT_CHARSET, withSrcDir);
    }

    public static File zip(String srcPath, String zipPath, java.nio.charset.Charset charset, boolean withSrcDir) throws InstrumentException {
        File srcFile = FileKit.file(srcPath);
        File zipFile = FileKit.file(zipPath);
        ZipKit.zip(zipFile, charset, withSrcDir, srcFile);
        return zipFile;
    }

    public static File zip(File zipFile, boolean withSrcDir, File ... srcFiles) throws InstrumentException {
        return ZipKit.zip(zipFile, DEFAULT_CHARSET, withSrcDir, srcFiles);
    }

    public static File zip(File zipFile, java.nio.charset.Charset charset, boolean withSrcDir, File ... srcFiles) throws InstrumentException {
        return ZipKit.zip(zipFile, charset, withSrcDir, null, srcFiles);
    }

    public static File zip(File zipFile, java.nio.charset.Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws InstrumentException {
        ZipKit.validateFiles(zipFile, srcFiles);
        try (ZipOutputStream out = ZipKit.getZipOutputStream(zipFile, charset);){
            ZipKit.zip((OutputStream)out, charset, withSrcDir, filter, srcFiles);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return zipFile;
    }

    public static void zip(OutputStream out, java.nio.charset.Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) {
        ZipKit.zip(ZipKit.getZipOutputStream(out, charset), withSrcDir, filter, srcFiles);
    }

    public static void zip(ZipOutputStream zipOutputStream, boolean withSrcDir, FileFilter filter, File ... srcFiles) {
        try {
            for (File srcFile : srcFiles) {
                if (null == srcFile) continue;
                String srcRootDir = srcFile.getCanonicalPath();
                if (srcFile.isFile() || withSrcDir) {
                    srcRootDir = srcFile.getCanonicalFile().getParentFile().getCanonicalPath();
                }
                ZipKit.zip(srcFile, srcRootDir, zipOutputStream, filter);
                zipOutputStream.flush();
            }
            zipOutputStream.finish();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static File zip(File zipFile, String path, String data) throws InstrumentException {
        return ZipKit.zip(zipFile, path, data, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, String data, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.zip(zipFile, path, IoKit.toStream(data, charset), charset);
    }

    public static File zip(File zipFile, String path, InputStream in) throws InstrumentException {
        return ZipKit.zip(zipFile, path, in, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, InputStream in, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.zip(zipFile, new String[]{path}, new InputStream[]{in}, charset);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins) throws InstrumentException {
        return ZipKit.zip(zipFile, paths, ins, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(File zipFile, String[] paths, InputStream[] ins, java.nio.charset.Charset charset) throws InstrumentException {
        if (ArrayKit.isEmpty(paths) || ArrayKit.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        ZipOutputStream out = null;
        try {
            out = ZipKit.getZipOutputStream(zipFile, charset);
            for (int i = 0; i < paths.length; ++i) {
                ZipKit.addFile(ins[i], paths[i], out);
            }
        }
        finally {
            IoKit.close(out);
        }
        return zipFile;
    }

    public static File unzip(String zipFilePath) throws InstrumentException {
        return ZipKit.unzip(zipFilePath, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.unzip(FileKit.file(zipFilePath), charset);
    }

    public static File unzip(File zipFile) throws InstrumentException {
        return ZipKit.unzip(zipFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.unzip(zipFile, FileKit.file(zipFile.getParentFile(), FileKit.mainName(zipFile)), charset);
    }

    public static File unzip(String zipFilePath, String outFileDir) throws InstrumentException {
        return ZipKit.unzip(zipFilePath, outFileDir, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, String outFileDir, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.unzip(FileKit.file(zipFilePath), FileKit.mkdir(outFileDir), charset);
    }

    public static File unzip(File zipFile, File outFile) throws InstrumentException {
        return ZipKit.unzip(zipFile, outFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, File outFile, java.nio.charset.Charset charset) throws InstrumentException {
        ZipFile zip;
        try {
            zip = new ZipFile(zipFile, charset);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return ZipKit.unzip(zip, outFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(ZipFile zipFile, File outFile) {
        try {
            Enumeration<? extends ZipEntry> em = zipFile.entries();
            while (em.hasMoreElements()) {
                ZipEntry zipEntry = em.nextElement();
                File outItemFile = FileKit.file(outFile, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                    continue;
                }
                ZipKit.write(zipFile, zipEntry, outItemFile);
            }
        }
        finally {
            IoKit.close(zipFile);
        }
        return outFile;
    }

    public static File unzip(InputStream in, File outFile, java.nio.charset.Charset charset) {
        if (null == charset) {
            charset = DEFAULT_CHARSET;
        }
        return ZipKit.unzip(new ZipInputStream(in, charset), outFile);
    }

    public static File unzip(ZipInputStream zipStream, File outFile) {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = zipStream.getNextEntry())) {
                File outItemFile = FileKit.file(outFile, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                    continue;
                }
                FileKit.writeFromStream((InputStream)zipStream, outItemFile);
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoKit.close(zipStream);
        }
        return outFile;
    }

    public static byte[] unzipFileBytes(String zipFilePath, String name) {
        return ZipKit.unzipFileBytes(zipFilePath, DEFAULT_CHARSET, name);
    }

    public static byte[] unzipFileBytes(String zipFilePath, java.nio.charset.Charset charset, String name) {
        return ZipKit.unzipFileBytes(FileKit.file(zipFilePath), charset, name);
    }

    public static byte[] unzipFileBytes(File zipFile, String name) {
        return ZipKit.unzipFileBytes(zipFile, DEFAULT_CHARSET, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzipFileBytes(File zipFile, java.nio.charset.Charset charset, String name) {
        ZipFile zipFileObj;
        block6: {
            byte[] byArray;
            block5: {
                zipFileObj = null;
                try {
                    zipFileObj = new ZipFile(zipFile, charset);
                    Enumeration<? extends ZipEntry> em = zipFileObj.entries();
                    while (em.hasMoreElements()) {
                        ZipEntry zipEntry = em.nextElement();
                        if (zipEntry.isDirectory() || !name.equals(zipEntry.getName())) continue;
                        byArray = IoKit.readBytes(zipFileObj.getInputStream(zipEntry));
                        break block5;
                    }
                    break block6;
                }
                catch (IOException e) {
                    try {
                        throw new InstrumentException(e);
                    }
                    catch (Throwable throwable) {
                        IoKit.close(zipFileObj);
                        throw throwable;
                    }
                }
            }
            IoKit.close(zipFileObj);
            return byArray;
        }
        IoKit.close(zipFileObj);
        return null;
    }

    public static byte[] gzip(String content, String charset) throws InstrumentException {
        return ZipKit.gzip(StringKit.bytes((CharSequence)content, charset));
    }

    public static byte[] gzip(byte[] buf) throws InstrumentException {
        return ZipKit.gzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] gzip(File file) throws InstrumentException {
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream(file);
            byte[] byArray = ZipKit.gzip(in, (int)file.length());
            return byArray;
        }
        finally {
            IoKit.close(in);
        }
    }

    public static byte[] gzip(InputStream in) throws InstrumentException {
        return ZipKit.gzip(in, 32);
    }

    public static byte[] gzip(InputStream in, int length) throws InstrumentException {
        java.io.ByteArrayOutputStream bos = new java.io.ByteArrayOutputStream(length);
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            IoKit.copy(in, gos);
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoKit.close(gos);
                throw throwable;
            }
        }
        IoKit.close(gos);
        return bos.toByteArray();
    }

    public static String unGzip(byte[] buf, String charset) throws InstrumentException {
        return StringKit.toString(ZipKit.unGzip(buf), charset);
    }

    public static byte[] unGzip(byte[] buf) throws InstrumentException {
        return ZipKit.unGzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unGzip(InputStream in) throws InstrumentException {
        return ZipKit.unGzip(in, 32);
    }

    public static byte[] unGzip(InputStream in, int length) throws InstrumentException {
        ByteArrayOutputStream bos;
        GZIPInputStream gzi = null;
        try {
            gzi = in instanceof GZIPInputStream ? (GZIPInputStream)in : new GZIPInputStream(in);
            bos = new ByteArrayOutputStream(length);
            IoKit.copy((InputStream)gzi, bos);
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoKit.close(gzi);
                throw throwable;
            }
        }
        IoKit.close(gzi);
        return bos.toByteArray();
    }

    public static byte[] zlib(String content, String charset, int level) {
        return ZipKit.zlib(StringKit.bytes((CharSequence)content, charset), level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlib(File file, int level) {
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream(file);
            byte[] byArray = ZipKit.zlib(in, level, (int)file.length());
            return byArray;
        }
        finally {
            IoKit.close(in);
        }
    }

    public static byte[] zlib(byte[] buf, int level) {
        return ZipKit.zlib(new ByteArrayInputStream(buf), level, buf.length);
    }

    public static byte[] zlib(InputStream in, int level) {
        return ZipKit.zlib(in, level, 32);
    }

    public static byte[] zlib(InputStream in, int level, int length) {
        java.io.ByteArrayOutputStream out = new java.io.ByteArrayOutputStream(length);
        ZipKit.deflater(in, out, level, false);
        return out.toByteArray();
    }

    public static String unZlib(byte[] buf, String charset) {
        return StringKit.toString(ZipKit.unZlib(buf), charset);
    }

    public static byte[] unZlib(byte[] buf) {
        return ZipKit.unZlib(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unZlib(InputStream in) {
        return ZipKit.unZlib(in, 32);
    }

    public static byte[] unZlib(InputStream in, int length) {
        java.io.ByteArrayOutputStream out = new java.io.ByteArrayOutputStream(length);
        ZipKit.inflater(in, out, false);
        return out.toByteArray();
    }

    public static List<String> listFileNames(ZipFile zipFile, String dir) {
        if (StringKit.isNotBlank(dir)) {
            dir = StringKit.addSuffixIfNot(dir, "/");
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            String nameSuffix;
            String name = zipEntry.getName();
            if (!StringKit.isEmpty(dir) && !name.startsWith(dir) || !StringKit.isNotEmpty(nameSuffix = StringKit.removePrefix(name, dir)) || StringKit.contains((CharSequence)nameSuffix, "/")) continue;
            fileNames.add(nameSuffix);
        }
        return fileNames;
    }

    private static ZipOutputStream getZipOutputStream(File zipFile, java.nio.charset.Charset charset) {
        return ZipKit.getZipOutputStream(FileKit.getOutputStream(zipFile), charset);
    }

    private static ZipOutputStream getZipOutputStream(OutputStream out, java.nio.charset.Charset charset) {
        if (out instanceof ZipOutputStream) {
            return (ZipOutputStream)out;
        }
        return new ZipOutputStream(out, ObjectKit.defaultIfNull(charset, DEFAULT_CHARSET));
    }

    private static void zip(File file, String srcRootDir, ZipOutputStream out, FileFilter filter) throws InstrumentException {
        if (null == file || null != filter && !filter.accept(file)) {
            return;
        }
        String subPath = FileKit.subPath(srcRootDir, file);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (ArrayKit.isEmpty(files) && StringKit.isNotEmpty(subPath)) {
                ZipKit.addDir(subPath, out);
            }
            for (File childFile : files) {
                ZipKit.zip(childFile, srcRootDir, out, filter);
            }
        } else {
            ZipKit.addFile(file, subPath, out);
        }
    }

    private static void addFile(File file, String path, ZipOutputStream out) throws InstrumentException {
        ZipKit.addFile(FileKit.getInputStream(file), path, out);
    }

    private static void addFile(InputStream in, String path, ZipOutputStream out) throws InstrumentException {
        if (null == in) {
            return;
        }
        try {
            out.putNextEntry(new ZipEntry(path));
            IoKit.copy(in, out);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoKit.close(in);
            ZipKit.closeEntry(out);
        }
    }

    private static void addDir(String path, ZipOutputStream out) throws InstrumentException {
        path = StringKit.addSuffixIfNot(path, "/");
        try {
            out.putNextEntry(new ZipEntry(path));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            ZipKit.closeEntry(out);
        }
    }

    private static void validateFiles(File zipFile, File ... srcFiles) throws InstrumentException {
        if (zipFile.isDirectory()) {
            throw new InstrumentException("Zip file [{}] must not be a directory !", zipFile.getAbsoluteFile());
        }
        for (File srcFile : srcFiles) {
            if (null == srcFile) continue;
            if (!srcFile.exists()) {
                throw new InstrumentException(StringKit.format("File [{}] not exist!", srcFile.getAbsolutePath()));
            }
            try {
                File parentFile = zipFile.getCanonicalFile().getParentFile();
                if (!srcFile.isDirectory() || !parentFile.getCanonicalPath().contains(srcFile.getCanonicalPath())) continue;
                throw new InstrumentException("Zip file path [{}] must not be the child directory of [{}] !", zipFile.getCanonicalPath(), srcFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new InstrumentException(e);
            }
        }
    }

    private static void closeEntry(ZipOutputStream out) {
        try {
            out.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void write(ZipFile zipFile, ZipEntry zipEntry, File outItemFile) throws InstrumentException {
        InputStream in = null;
        try {
            in = zipFile.getInputStream(zipEntry);
            FileKit.writeFromStream(in, outItemFile);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoKit.close(in);
        }
    }

    private static void inflater(InputStream in, OutputStream out, boolean nowrap) {
        InflaterOutputStream ios = out instanceof InflaterOutputStream ? (InflaterOutputStream)out : new InflaterOutputStream(out, new Inflater(nowrap));
        IoKit.copy(in, ios);
        try {
            ios.finish();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    private static void deflater(InputStream in, OutputStream out, int level, boolean nowrap) {
        DeflaterOutputStream ios = out instanceof DeflaterOutputStream ? (DeflaterOutputStream)out : new DeflaterOutputStream(out, new Deflater(level, nowrap));
        IoKit.copy(in, ios);
        try {
            ios.finish();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    private static File buildFile(File outFile, String fileName) {
        fileName = fileName.replace('\\', '/');
        if (!FileKit.isWindows() && fileName.lastIndexOf("/", fileName.length() - 2) > 0) {
            List<String> pathParts = StringKit.split(fileName, '/', false, true);
            int lastPartIndex = pathParts.size() - 1;
            for (int i = 0; i < lastPartIndex; ++i) {
                outFile = new File(outFile, pathParts.get(i));
            }
            outFile.mkdirs();
            fileName = pathParts.get(lastPartIndex);
        }
        return FileKit.file(outFile, fileName);
    }

    public static String compress(String body) {
        if (StringKit.isEmpty(body)) {
            return body;
        }
        try {
            java.io.ByteArrayOutputStream outputStream = ZipKit.compressToStream(body);
            if (outputStream != null) {
                return new String(outputStream.toByteArray(), Charset.ISO_8859_1);
            }
        }
        catch (Exception e) {
            Console.log("GZIP compress \u538b\u7f29\u5931\u8d25\uff0c\u4f7f\u7528\u6e90\u6587\u4ef6", e);
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.io.ByteArrayOutputStream compressToStream(String body) {
        java.io.ByteArrayOutputStream bos = new java.io.ByteArrayOutputStream();
        GZIPOutputStream os = null;
        try {
            os = new GZIPOutputStream(bos);
            os.write(body.getBytes());
            java.io.ByteArrayOutputStream byteArrayOutputStream = bos;
            return byteArrayOutputStream;
        }
        catch (IOException e) {
            Console.log("Compression failed, using source file", e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(String body) {
        if (StringKit.isEmpty(body)) {
            return body;
        }
        byte[] buf = new byte[1024];
        ByteArrayInputStream bis = null;
        java.io.ByteArrayOutputStream bos = new java.io.ByteArrayOutputStream();
        GZIPInputStream is = null;
        try {
            int len;
            bis = new ByteArrayInputStream(body.getBytes(Charset.ISO_8859_1));
            is = new GZIPInputStream(bis);
            while ((len = is.read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
            String string = new String(bos.toByteArray());
            return string;
        }
        catch (Exception e) {
            Console.log("Decompress failed, using source file", e);
            String string = body;
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

