/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.digest.mac;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.digest.mac.MacEngine;

public class DefaultHMacEngine
implements MacEngine {
    private Mac mac;

    public DefaultHMacEngine(String algorithm, byte[] key) {
        this.init(algorithm, key);
    }

    public DefaultHMacEngine(String algorithm, Key key) {
        this.init(algorithm, key);
    }

    public DefaultHMacEngine init(String algorithm, byte[] key) {
        return this.init(algorithm, null == key ? null : new SecretKeySpec(key, algorithm));
    }

    public DefaultHMacEngine init(String algorithm, Key key) {
        try {
            this.mac = Builder.createMac(algorithm);
            if (null == key) {
                key = Builder.generateKey(algorithm);
            }
            this.mac.init(key);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        return this;
    }

    @Override
    public byte[] digest(InputStream data, int bufferLength) {
        byte[] result;
        if (bufferLength < 1) {
            bufferLength = 8192;
        }
        byte[] buffer = new byte[bufferLength];
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.mac.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            result = this.mac.doFinal();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public Mac getMac() {
        return this.mac;
    }

    @Override
    public int getMacLength() {
        return this.mac.getMacLength();
    }

    @Override
    public String getAlgorithm() {
        return this.mac.getAlgorithm();
    }
}

