/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.captcha.strategy;

import org.aoju.bus.core.math.Calculator;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.captcha.strategy.CodeStrategy;

public class MathStrategy
implements CodeStrategy {
    private final int numberLength;

    public MathStrategy() {
        this(2);
    }

    public MathStrategy(int numberLength) {
        this.numberLength = numberLength;
    }

    @Override
    public String generate() {
        int limit = this.getLimit();
        String number1 = Integer.toString(RandomKit.randomInt(limit));
        String number2 = Integer.toString(RandomKit.randomInt(limit));
        number1 = StringKit.padAfter((CharSequence)number1, this.numberLength, ' ');
        number2 = StringKit.padAfter((CharSequence)number2, this.numberLength, ' ');
        return StringKit.builder().append(number1).append(RandomKit.randomChar("+-*")).append(number2).append('=').toString();
    }

    @Override
    public boolean verify(String code, String userInputCode) {
        int result;
        try {
            result = Integer.parseInt(userInputCode);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int calculateResult = (int)Calculator.conversion(code);
        return result == calculateResult;
    }

    public int getLength() {
        return this.numberLength * 2 + 2;
    }

    private int getLimit() {
        return Integer.parseInt('1' + StringKit.repeat('0', this.numberLength));
    }
}

