/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.reactor;

import java.util.List;
import java.util.Set;
import org.aoju.bus.core.collection.ConcurrentHashSet;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.goalie.reactor.Asset;
import org.aoju.bus.goalie.reactor.AssetRegistry;
import org.aoju.bus.logger.Logger;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;

public class Athlete {
    private final HttpServer httpServer;
    private final Set<Asset> assets = new ConcurrentHashSet<Asset>();
    private final List<AssetRegistry> assetRegistries;
    private DisposableServer disposableServer;

    public Athlete(HttpServer httpServer, List<AssetRegistry> assetRegistries) {
        this.httpServer = httpServer;
        this.assetRegistries = assetRegistries;
    }

    public Set<Asset> getAssets() {
        return this.assets;
    }

    private void init() {
        if (CollKit.isNotEmpty(this.assetRegistries)) {
            this.assetRegistries.forEach(assetRegistry -> this.assets.addAll(assetRegistry.init()));
        }
        this.disposableServer = this.httpServer.bindNow();
        Logger.info("reactor server start on port:{} success", this.disposableServer.port());
    }

    private void destroy() {
        this.disposableServer.disposeNow();
        Logger.info("reactor server stop on port:{} success", this.disposableServer.port());
    }
}

