/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.reactor;

import java.util.Map;
import java.util.Optional;
import org.aoju.bus.goalie.reactor.Asset;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;

public class ExchangeContext {
    private static final String $ = "exchange_context";
    private Map<String, String> requestMap;
    private Flux<DataBuffer> body;
    private Asset asset;

    public static ExchangeContext get(ServerWebExchange exchange) {
        ExchangeContext context = (ExchangeContext)exchange.getAttribute($);
        return Optional.ofNullable(context).orElseGet(() -> {
            ExchangeContext empty = new ExchangeContext();
            exchange.getAttributes().put($, empty);
            return empty;
        });
    }

    public static ExchangeContext get(ServerRequest request) {
        return (ExchangeContext)request.attribute($).orElseGet(() -> {
            ExchangeContext empty = new ExchangeContext();
            request.attributes().put($, empty);
            return empty;
        });
    }

    public Map<String, String> getRequestMap() {
        return this.requestMap;
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setRequestMap(Map<String, String> requestMap) {
        this.requestMap = requestMap;
    }

    public void setBody(Flux<DataBuffer> body) {
        this.body = body;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExchangeContext)) {
            return false;
        }
        ExchangeContext other = (ExchangeContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$requestMap = this.getRequestMap();
        Map<String, String> other$requestMap = other.getRequestMap();
        if (this$requestMap == null ? other$requestMap != null : !((Object)this$requestMap).equals(other$requestMap)) {
            return false;
        }
        Flux<DataBuffer> this$body = this.getBody();
        Flux<DataBuffer> other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        return !(this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExchangeContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $requestMap = this.getRequestMap();
        result = result * 59 + ($requestMap == null ? 43 : ((Object)$requestMap).hashCode());
        Flux<DataBuffer> $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        return result;
    }

    public String toString() {
        return "ExchangeContext(requestMap=" + this.getRequestMap() + ", body=" + this.getBody() + ", asset=" + this.getAsset() + ")";
    }
}

