/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.reactor;

import com.alibaba.fastjson.JSON;
import java.net.ConnectException;
import java.util.Map;
import org.aoju.bus.base.consts.ErrorCode;
import org.aoju.bus.base.spring.Controller;
import org.aoju.bus.core.lang.exception.BusinessException;
import org.aoju.bus.core.toolkit.RuntimeKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.goalie.reactor.ExchangeContext;
import org.aoju.bus.logger.Logger;
import org.reactivestreams.Publisher;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class GlobalExceptionHandler
extends Controller
implements ErrorWebExceptionHandler {
    @NonNull
    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        BusinessException e;
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode(HttpStatus.BAD_REQUEST);
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        Map<String, String> map = ExchangeContext.get(exchange).getRequestMap();
        String method = null;
        if (null != map) {
            method = map.get("method");
        }
        Logger.error("request: {},error:{}", method, RuntimeKit.getMessage(ex));
        Object message = ex instanceof ConnectException ? Controller.write(ErrorCode.EM_FAILURE) : (ex instanceof BusinessException ? (StringKit.isNotBlank((e = (BusinessException)ex).getErrcode()) ? Controller.write(e.getErrcode()) : Controller.write(ErrorCode.EM_100513, e.getMessage())) : Controller.write(ErrorCode.EM_100513));
        DataBuffer db = response.bufferFactory().wrap(JSON.toJSONString((Object)message).getBytes());
        return response.writeWith((Publisher)Mono.just((Object)db));
    }
}

