/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.reactor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.base.consts.ErrorCode;
import org.aoju.bus.core.lang.exception.BusinessException;
import org.aoju.bus.goalie.reactor.Asset;
import org.aoju.bus.goalie.reactor.ExchangeContext;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class RouterHandler {
    private final Map<String, WebClient> clients = new ConcurrentHashMap<String, WebClient>();

    @NonNull
    public Mono<ServerResponse> handle(ServerRequest request) {
        ExchangeContext context = ExchangeContext.get(request);
        Asset asset = context.getAsset();
        Map<String, String> params = context.getRequestMap();
        String baseUrl = asset.getHost() + ':' + asset.getPort();
        WebClient webClient = this.clients.computeIfAbsent(baseUrl, client -> WebClient.create((String)baseUrl));
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)baseUrl).path(asset.getUrl());
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.setAll(params);
        if (HttpMethod.GET.equals((Object)asset.getHttpMethod())) {
            builder.queryParams((MultiValueMap)multiValueMap);
        }
        WebClient.RequestBodySpec bodySpec = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.method(asset.getHttpMethod()).uri(builder.build().toUri())).headers(headers -> request.headers());
        if (!HttpMethod.GET.equals((Object)asset.getHttpMethod())) {
            bodySpec.bodyValue((Object)multiValueMap);
        }
        return bodySpec.exchange().flatMap(clientResponse -> {
            if (clientResponse.statusCode().is2xxSuccessful()) {
                Flux flux = (Flux)clientResponse.body(BodyExtractors.toDataBuffers());
                context.setBody((Flux<DataBuffer>)flux);
                return ServerResponse.ok().contentType(MediaType.APPLICATION_JSON).body((Publisher)flux, DataBuffer.class);
            }
            return Mono.error((Throwable)new BusinessException(ErrorCode.EM_100509));
        });
    }
}

