/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.drivers;

import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Builder;

@ThreadSafe
public final class Sysfs {
    private Sysfs() {
    }

    public static String querySystemVendor() {
        String sysVendor = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/sys_vendor").trim();
        if (!sysVendor.isEmpty()) {
            return sysVendor;
        }
        return null;
    }

    public static String queryProductModel() {
        String productName = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/product_name").trim();
        String productVersion = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/product_version").trim();
        if (productName.isEmpty()) {
            if (!productVersion.isEmpty()) {
                return productVersion;
            }
        } else {
            if (!productVersion.isEmpty() && !"None".equals(productVersion)) {
                return productName + " (version: " + productVersion + ")";
            }
            return productName;
        }
        return null;
    }

    public static String queryProductSerial() {
        String serial = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/product_serial");
        if (!serial.isEmpty() && !"None".equals(serial)) {
            return serial;
        }
        return Sysfs.queryBoardSerial();
    }

    public static String queryBoardVendor() {
        String boardVendor = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_vendor").trim();
        if (!boardVendor.isEmpty()) {
            return boardVendor;
        }
        return null;
    }

    public static String queryBoardModel() {
        String boardName = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_name").trim();
        if (!boardName.isEmpty()) {
            return boardName;
        }
        return null;
    }

    public static String queryBoardVersion() {
        String boardVersion = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_version").trim();
        if (!boardVersion.isEmpty()) {
            return boardVersion;
        }
        return null;
    }

    public static String queryBoardSerial() {
        String boardSerial = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_serial").trim();
        if (!boardSerial.isEmpty()) {
            return boardSerial;
        }
        return null;
    }

    public static String queryBiosVendor() {
        String biosVendor = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/bios_vendor").trim();
        if (biosVendor.isEmpty()) {
            return biosVendor;
        }
        return null;
    }

    public static String queryBiosDescription() {
        String modalias = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/modalias").trim();
        if (!modalias.isEmpty()) {
            return modalias;
        }
        return null;
    }

    public static String queryBiosVersion(String biosRevision) {
        String biosVersion = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/bios_version").trim();
        if (!biosVersion.isEmpty()) {
            return biosVersion + (StringKit.isBlank(biosRevision) ? "" : " (revision " + biosRevision + ")");
        }
        return null;
    }

    public static String queryBiosReleaseDate() {
        String biosDate = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/bios_date").trim();
        if (!biosDate.isEmpty()) {
            return Builder.parseMmDdYyyyToYyyyMmDD(biosDate);
        }
        return null;
    }
}

