/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.drivers;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.builtin.software.OSSession;
import org.aoju.bus.health.mac.SystemB;

@ThreadSafe
public final class Who {
    private static final SystemB SYS = SystemB.INSTANCE;

    private Who() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<OSSession> queryUtxent() {
        ArrayList<OSSession> whoList = new ArrayList<OSSession>();
        SYS.setutxent();
        try {
            SystemB.MacUtmpx ut;
            while ((ut = SYS.getutxent()) != null) {
                if (ut.ut_type != 7 && ut.ut_type != 6) continue;
                String user = new String(ut.ut_user, StandardCharsets.US_ASCII).trim();
                String device = new String(ut.ut_line, StandardCharsets.US_ASCII).trim();
                String host = new String(ut.ut_host, StandardCharsets.US_ASCII).trim();
                long loginTime = ut.ut_tv.tv_sec.longValue() * 1000L + (long)ut.ut_tv.tv_usec / 1000L;
                if (user.isEmpty() || device.isEmpty() || loginTime < 0L || loginTime > System.currentTimeMillis()) {
                    List<OSSession> list = org.aoju.bus.health.unix.Who.queryWho();
                    return list;
                }
                whoList.add(new OSSession(user, device, loginTime, host));
            }
        }
        finally {
            SYS.endutxent();
        }
        return whoList;
    }
}

