/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.hardware;

import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.builtin.hardware.AbstractVirtualMemory;
import org.aoju.bus.health.unix.aix.Perfstat;

@ThreadSafe
final class AixVirtualMemory
extends AbstractVirtualMemory {
    private static final long PAGESIZE = 4096L;
    private final Supplier<Perfstat.perfstat_memory_total_t> perfstatMem;

    AixVirtualMemory(Supplier<Perfstat.perfstat_memory_total_t> perfstatMem) {
        this.perfstatMem = perfstatMem;
    }

    @Override
    public long getSwapUsed() {
        Perfstat.perfstat_memory_total_t perfstat = this.perfstatMem.get();
        return (perfstat.pgsp_total - perfstat.pgsp_free) * 4096L;
    }

    @Override
    public long getSwapTotal() {
        return this.perfstatMem.get().pgsp_total * 4096L;
    }

    @Override
    public long getVirtualMax() {
        return this.perfstatMem.get().virt_total * 4096L;
    }

    @Override
    public long getVirtualInUse() {
        return this.perfstatMem.get().virt_active * 4096L;
    }

    @Override
    public long getSwapPagesIn() {
        return this.perfstatMem.get().pgspins;
    }

    @Override
    public long getSwapPagesOut() {
        return this.perfstatMem.get().pgspouts;
    }
}

