/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.software;

import com.sun.jna.Memory;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;
import org.aoju.bus.health.mac.SysctlKit;
import org.aoju.bus.health.unix.CLibrary;
import org.aoju.bus.health.unix.NetStatTcp;

@ThreadSafe
public class FreeBsdInternetProtocolStats
implements InternetProtocolStats {
    private final Supplier<CLibrary.BsdTcpstat> tcpstat = Memoize.memoize(FreeBsdInternetProtocolStats::queryTcpstat, Memoize.defaultExpiration());
    private final Supplier<CLibrary.BsdUdpstat> udpstat = Memoize.memoize(FreeBsdInternetProtocolStats::queryUdpstat, Memoize.defaultExpiration());
    private Supplier<Pair<Long, Long>> establishedv4v6 = Memoize.memoize(NetStatTcp::queryTcpnetstat, Memoize.defaultExpiration());

    private static CLibrary.BsdTcpstat queryTcpstat() {
        CLibrary.BsdTcpstat ft = new CLibrary.BsdTcpstat();
        Memory m = SysctlKit.sysctl("net.inet.tcp.stats");
        if (m != null && m.size() >= 128L) {
            ft.tcps_connattempt = m.getInt(0L);
            ft.tcps_accepts = m.getInt(4L);
            ft.tcps_drops = m.getInt(12L);
            ft.tcps_conndrops = m.getInt(16L);
            ft.tcps_sndpack = m.getInt(64L);
            ft.tcps_sndrexmitpack = m.getInt(72L);
            ft.tcps_rcvpack = m.getInt(104L);
            ft.tcps_rcvbadsum = m.getInt(112L);
            ft.tcps_rcvbadoff = m.getInt(116L);
            ft.tcps_rcvmemdrop = m.getInt(120L);
            ft.tcps_rcvshort = m.getInt(124L);
        }
        return ft;
    }

    private static CLibrary.BsdUdpstat queryUdpstat() {
        CLibrary.BsdUdpstat ut = new CLibrary.BsdUdpstat();
        Memory m = SysctlKit.sysctl("net.inet.udp.stats");
        if (m != null && m.size() >= 1644L) {
            ut.udps_ipackets = m.getInt(0L);
            ut.udps_hdrops = m.getInt(4L);
            ut.udps_badsum = m.getInt(8L);
            ut.udps_badlen = m.getInt(12L);
            ut.udps_opackets = m.getInt(36L);
            ut.udps_noportmcast = m.getInt(48L);
            ut.udps_rcv6_swcsum = m.getInt(64L);
            ut.udps_snd6_swcsum = m.getInt(80L);
        }
        return ut;
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv6Stats() {
        return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getRight(), 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        CLibrary.BsdTcpstat tcp = this.tcpstat.get();
        return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getLeft(), Builder.unsignedIntToLong(tcp.tcps_connattempt), Builder.unsignedIntToLong(tcp.tcps_accepts), Builder.unsignedIntToLong(tcp.tcps_conndrops), Builder.unsignedIntToLong(tcp.tcps_drops), Builder.unsignedIntToLong(tcp.tcps_sndpack), Builder.unsignedIntToLong(tcp.tcps_rcvpack), Builder.unsignedIntToLong(tcp.tcps_sndrexmitpack), Builder.unsignedIntToLong(tcp.tcps_rcvbadsum + tcp.tcps_rcvbadoff + tcp.tcps_rcvmemdrop + tcp.tcps_rcvshort), 0L);
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        CLibrary.BsdUdpstat stat = this.udpstat.get();
        return new InternetProtocolStats.UdpStats(Builder.unsignedIntToLong(stat.udps_opackets), Builder.unsignedIntToLong(stat.udps_ipackets), Builder.unsignedIntToLong(stat.udps_noportmcast), Builder.unsignedIntToLong(stat.udps_hdrops + stat.udps_badsum + stat.udps_badlen));
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        CLibrary.BsdUdpstat stat = this.udpstat.get();
        return new InternetProtocolStats.UdpStats(Builder.unsignedIntToLong(stat.udps_snd6_swcsum), Builder.unsignedIntToLong(stat.udps_rcv6_swcsum), 0L, 0L);
    }
}

