/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.software;

import com.sun.jna.Native;
import com.sun.jna.ptr.PointerByReference;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractNetworkParams;
import org.aoju.bus.health.unix.CLibrary;
import org.aoju.bus.health.unix.freebsd.FreeBsdLibc;
import org.aoju.bus.logger.Logger;

@ThreadSafe
final class FreeBsdNetworkParams
extends AbstractNetworkParams {
    private static final FreeBsdLibc LIBC = FreeBsdLibc.INSTANCE;

    FreeBsdNetworkParams() {
    }

    @Override
    public String getDomainName() {
        PointerByReference ptr;
        CLibrary.Addrinfo hint = new CLibrary.Addrinfo();
        hint.ai_flags = 2;
        String hostname = this.getHostName();
        int res = LIBC.getaddrinfo(hostname, null, hint, ptr = new PointerByReference());
        if (res > 0) {
            if (Logger.get().isError()) {
                Logger.warn("Failed getaddrinfo(): {}", LIBC.gai_strerror(res));
            }
            return "";
        }
        CLibrary.Addrinfo info = new CLibrary.Addrinfo(ptr.getValue());
        String canonname = info.ai_canonname.trim();
        LIBC.freeaddrinfo(ptr.getValue());
        return canonname;
    }

    @Override
    public String getHostName() {
        byte[] hostnameBuffer = new byte[256];
        if (0 != LIBC.gethostname(hostnameBuffer, hostnameBuffer.length)) {
            return super.getHostName();
        }
        return Native.toString((byte[])hostnameBuffer);
    }

    @Override
    public String getIpv4DefaultGateway() {
        return FreeBsdNetworkParams.searchGateway(Executor.runNative("route -4 get default"));
    }

    @Override
    public String getIpv6DefaultGateway() {
        return FreeBsdNetworkParams.searchGateway(Executor.runNative("route -6 get default"));
    }
}

