/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.software;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.IPHlpAPI;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.ptr.IntByReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractNetworkParams;
import org.aoju.bus.logger.Logger;

@ThreadSafe
final class WindowsNetworkParams
extends AbstractNetworkParams {
    private static final int COMPUTER_NAME_DNS_DOMAIN_FULLY_QUALIFIED = 3;

    WindowsNetworkParams() {
    }

    private static String parseIpv4Route() {
        List<String> lines = Executor.runNative("route print -4 0.0.0.0");
        for (String line : lines) {
            String[] fields = RegEx.SPACES.split(line.trim());
            if (fields.length <= 2 || !"0.0.0.0".equals(fields[0])) continue;
            return fields[2];
        }
        return "";
    }

    private static String parseIpv6Route() {
        List<String> lines = Executor.runNative("route print -6 ::/0");
        for (String line : lines) {
            String[] fields = RegEx.SPACES.split(line.trim());
            if (fields.length <= 3 || !"::/0".equals(fields[2])) continue;
            return fields[3];
        }
        return "";
    }

    @Override
    public String getDomainName() {
        char[] buffer = new char[256];
        IntByReference bufferSize = new IntByReference(buffer.length);
        if (!Kernel32.INSTANCE.GetComputerNameEx(3, buffer, bufferSize)) {
            Logger.error("Failed to get dns domain name. Error code: {}", Kernel32.INSTANCE.GetLastError());
            return "";
        }
        return new String(buffer).trim();
    }

    @Override
    public String[] getDnsServers() {
        IntByReference bufferSize = new IntByReference();
        int ret = IPHlpAPI.INSTANCE.GetNetworkParams(null, bufferSize);
        if (ret != 111) {
            Logger.error("Failed to get network parameters buffer size. Error code: {}", ret);
            return new String[0];
        }
        Memory buffer = new Memory((long)bufferSize.getValue());
        ret = IPHlpAPI.INSTANCE.GetNetworkParams((Pointer)buffer, bufferSize);
        if (ret != 0) {
            Logger.error("Failed to get network parameters. Error code: {}", ret);
            return new String[0];
        }
        IPHlpAPI.FIXED_INFO fixedInfo = new IPHlpAPI.FIXED_INFO((Pointer)buffer);
        ArrayList<String> list = new ArrayList<String>();
        IPHlpAPI.IP_ADDR_STRING dns = fixedInfo.DnsServerList;
        while (dns != null) {
            String addr = new String(dns.IpAddress.String, StandardCharsets.US_ASCII);
            int nullPos = addr.indexOf(0);
            if (nullPos != -1) {
                addr = addr.substring(0, nullPos);
            }
            list.add(addr);
            dns = dns.Next;
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String getHostName() {
        return Kernel32Util.getComputerName();
    }

    @Override
    public String getIpv4DefaultGateway() {
        return WindowsNetworkParams.parseIpv4Route();
    }

    @Override
    public String getIpv6DefaultGateway() {
        return WindowsNetworkParams.parseIpv6Route();
    }
}

