/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric.http;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.Httpv;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.Results;
import org.aoju.bus.http.magic.RealResult;
import org.aoju.bus.http.metric.Cancelable;
import org.aoju.bus.http.metric.http.CoverHttp;

public class SyncHttp
extends CoverHttp<SyncHttp> {
    public SyncHttp(Httpv client, String url) {
        super(client, url);
    }

    public Results get() {
        return this.request("GET");
    }

    public Results head() {
        return this.request("HEAD");
    }

    public Results post() {
        return this.request("POST");
    }

    public Results put() {
        return this.request("PUT");
    }

    public Results patch() {
        return this.request("PATCH");
    }

    public Results delete() {
        return this.request("DELETE");
    }

    public Results request(String method) {
        if (method == null || method.isEmpty()) {
            throw new IllegalArgumentException("Request method method cannot be empty!");
        }
        RealResult result = new RealResult(this, this.httpClient.executor());
        SyncHttpCall httpCall = new SyncHttpCall();
        this.registeTagTask(httpCall);
        CountDownLatch latch = new CountDownLatch(1);
        this.httpClient.preprocess(this, () -> {
            SyncHttpCall syncHttpCall = httpCall;
            synchronized (syncHttpCall) {
                if (httpCall.canceled) {
                    result.exception(Results.State.CANCELED, null);
                    latch.countDown();
                    return;
                }
                httpCall.call = this.prepareCall(method);
            }
            try {
                result.response(httpCall.call.execute());
                httpCall.done = true;
            }
            catch (IOException e) {
                result.exception(this.toState(e), e);
            }
            finally {
                latch.countDown();
            }
        }, this.skipPreproc, this.skipSerialPreproc);
        boolean timeout = false;
        if (result.getState() == null) {
            timeout = !this.timeoutAwait(latch);
        }
        this.removeTagTask();
        if (timeout) {
            httpCall.cancel();
            return this.timeoutResult();
        }
        IOException e = result.getError();
        Results.State state = result.getState();
        if (e != null && state != Results.State.CANCELED && !this.nothrow) {
            throw new InstrumentException("Abnormal execution", e);
        }
        return result;
    }

    static class SyncHttpCall
    implements Cancelable {
        NewCall call;
        boolean done = false;
        boolean canceled = false;

        SyncHttpCall() {
        }

        @Override
        public synchronized boolean cancel() {
            if (this.done) {
                return false;
            }
            if (this.call != null) {
                this.call.cancel();
            }
            this.canceled = true;
            return true;
        }
    }
}

