/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.socket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.aoju.bus.core.io.ByteString;
import org.aoju.bus.http.bodys.AbstractBody;
import org.aoju.bus.http.metric.TaskExecutor;
import org.aoju.bus.http.socket.WebSocketCover;

public class WebSocketMessage
extends AbstractBody
implements WebSocketCover.Sockets.Message {
    private String text;
    private ByteString bytes;

    public WebSocketMessage(String text, TaskExecutor taskExecutor, Charset charset) {
        super(taskExecutor, charset);
        this.text = text;
    }

    public WebSocketMessage(ByteString bytes, TaskExecutor taskExecutor, Charset charset) {
        super(taskExecutor, charset);
        this.bytes = bytes;
    }

    @Override
    public boolean isText() {
        return this.text != null;
    }

    @Override
    public byte[] toBytes() {
        if (this.text != null) {
            return this.text.getBytes(StandardCharsets.UTF_8);
        }
        if (this.bytes != null) {
            return this.bytes.toByteArray();
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.text != null) {
            return this.text;
        }
        if (this.bytes != null) {
            return this.bytes.utf8();
        }
        return null;
    }

    @Override
    public ByteString toByteString() {
        if (this.text != null) {
            return ByteString.encodeUtf8(this.text);
        }
        return this.bytes;
    }

    @Override
    public Reader toCharStream() {
        return new InputStreamReader(this.toByteStream());
    }

    @Override
    public InputStream toByteStream() {
        if (this.text != null) {
            return new ByteArrayInputStream(this.text.getBytes(StandardCharsets.UTF_8));
        }
        if (this.bytes != null) {
            final ByteBuffer buffer = this.bytes.asByteBuffer();
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    if (buffer.hasRemaining()) {
                        return buffer.get();
                    }
                    return -1;
                }
            };
        }
        return null;
    }
}

