/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.pdu;

import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.Property;

public class ExtendedNegotiate {
    private final String cuid;
    private final byte[] info;

    public ExtendedNegotiate(String cuid, byte[] info) {
        if (cuid == null) {
            throw new NullPointerException();
        }
        this.cuid = cuid;
        this.info = (byte[])info.clone();
    }

    public final String getSOPClassUID() {
        return this.cuid;
    }

    public final byte[] getInformation() {
        return (byte[])this.info.clone();
    }

    public final byte getField(int index, byte def) {
        return index < this.info.length ? this.info[index] : def;
    }

    public int length() {
        return this.cuid.length() + this.info.length + 2;
    }

    public String toString() {
        return this.promptTo(new StringBuilder()).toString();
    }

    StringBuilder promptTo(StringBuilder sb) {
        sb.append("  ExtendedNegotiation[").append(Property.LINE_SEPARATOR).append("    sopClass: ");
        UID.promptTo(this.cuid, sb).append(Property.LINE_SEPARATOR).append("    info: [");
        for (byte b : this.info) {
            sb.append(b).append(", ");
        }
        return sb.append(']').append(Property.LINE_SEPARATOR).append("  ]");
    }
}

