/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Editors;
import org.aoju.bus.image.Node;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.Tag;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ContentHandlerAdapter;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.galaxy.io.SAXReader;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.AttributeContext;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.DataWriter;
import org.aoju.bus.image.metric.DataWriterAdapter;
import org.aoju.bus.image.metric.DimseRSP;
import org.aoju.bus.image.metric.DimseRSPHandler;
import org.aoju.bus.image.metric.InputStreamWriter;
import org.aoju.bus.image.metric.Progress;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQ;
import org.aoju.bus.image.metric.internal.pdu.CommonExtended;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.image.nimble.codec.Decompressor;
import org.aoju.bus.logger.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StoreSCU
implements AutoCloseable {
    private static SAXParser saxParser;
    public final SOPClasses relSOPClasses = new SOPClasses();
    private final ApplicationEntity ae;
    private final Connection remote;
    private final AAssociateRQ rq = new AAssociateRQ();
    private final Editors attributesEditors;
    private final Status state;
    private Attributes attrs;
    private String uidSuffix;
    private boolean relExtNeg;
    private int priority;
    private String tmpPrefix = "storescu-";
    private String tmpSuffix;
    private File tmpDir;
    private File tmpFile;
    private Association as;
    private long totalSize = 0L;
    private int filesScanned;
    private RSPHandlerFactory rspHandlerFactory = file -> new DimseRSPHandler(this.as.nextMessageID()){

        @Override
        public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
            super.onDimseRSP(as, cmd, data);
            StoreSCU.this.onCStoreRSP(cmd, file);
            Progress progress = StoreSCU.this.state.getProgress();
            if (progress != null) {
                progress.setProcessedFile(file);
                progress.setAttributes(cmd);
            }
        }
    };

    public StoreSCU(ApplicationEntity ae, Progress progress) throws IOException {
        this(ae, progress, null);
    }

    public StoreSCU(ApplicationEntity ae, Progress progress, Editors attributesEditors) {
        this.remote = new Connection();
        this.ae = ae;
        this.rq.addPresentationContext(new Presentation(1, "1.2.840.10008.1.1", "1.2.840.10008.1.2"));
        this.state = new Status(progress);
        this.attributesEditors = attributesEditors;
    }

    public static boolean updateAttributes(Attributes data, Attributes attrs, String uidSuffix) {
        if (attrs.isEmpty() && uidSuffix == null) {
            return false;
        }
        if (uidSuffix != null) {
            data.setString(0x20000D, VR.UI, data.getString(0x20000D) + uidSuffix);
            data.setString(0x20000E, VR.UI, data.getString(0x20000E) + uidSuffix);
            data.setString(524312, VR.UI, data.getString(524312) + uidSuffix);
        }
        data.update(Attributes.UpdatePolicy.OVERWRITE, attrs, null);
        return true;
    }

    public static void scan(List<String> fnames, Callback scb) {
        StoreSCU.scan(fnames, true, scb);
    }

    public static void scan(List<String> fnames, boolean printout, Callback scb) {
        for (String fname : fnames) {
            StoreSCU.scan(new File(fname), printout, scb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void scan(File f, boolean printout, Callback scb) {
        ImageInputStream in;
        block12: {
            if (f.isDirectory()) {
                for (String s : f.list()) {
                    StoreSCU.scan(new File(f, s), printout, scb);
                }
                return;
            }
            if (f.getName().endsWith(".xml")) {
                try {
                    SAXParser p = saxParser;
                    if (p == null) {
                        SAXParserFactory factory = SAXParserFactory.newInstance();
                        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        saxParser = p = factory.newSAXParser();
                    }
                    Attributes ds = new Attributes();
                    ContentHandlerAdapter ch = new ContentHandlerAdapter(ds);
                    p.parse(f, (DefaultHandler)ch);
                    Attributes fmi = ch.getFileMetaInformation();
                    if (fmi == null) {
                        fmi = ds.createFileMetaInformation("1.2.840.10008.1.2.1");
                    }
                    boolean b = scb.dicomFile(f, fmi, -1L, ds);
                    if (!printout) return;
                    Logger.debug(String.valueOf(b ? (char)'.' : 'I'), new Object[0]);
                    return;
                }
                catch (Exception e) {
                    Logger.error("Failed to parse file " + f + ": " + e.getMessage(), new Object[0]);
                    e.printStackTrace(System.out);
                }
                return;
            }
            in = null;
            try {
                in = new ImageInputStream(f);
                in.setIncludeBulkData(ImageInputStream.IncludeBulkData.NO);
                Attributes fmi = in.readFileMetaInformation();
                long dsPos = in.getPosition();
                Attributes ds = in.readDataset(-1, 2145386512);
                if (!(fmi != null && fmi.containsValue(131088) && fmi.containsValue(131074) && fmi.containsValue(131075))) {
                    fmi = ds.createFileMetaInformation(in.getTransferSyntax());
                }
                boolean b = scb.dicomFile(f, fmi, dsPos, ds);
                if (!printout) break block12;
                Logger.debug(String.valueOf(b ? (char)'.' : 'I'), new Object[0]);
            }
            catch (Exception e) {
                try {
                    Logger.error("Failed to scan file " + f + ": " + e.getMessage(), new Object[0]);
                }
                catch (Throwable throwable) {
                    IoKit.close(in);
                    throw throwable;
                }
                IoKit.close(in);
                return;
            }
        }
        IoKit.close(in);
        return;
    }

    public static String selectTransferSyntax(Association as, String cuid, String filets) {
        Set<String> tss = as.getTransferSyntaxesFor(cuid);
        if (tss.contains(filets)) {
            return filets;
        }
        if (tss.contains("1.2.840.10008.1.2.1")) {
            return "1.2.840.10008.1.2.1";
        }
        return "1.2.840.10008.1.2";
    }

    public void setRspHandlerFactory(RSPHandlerFactory rspHandlerFactory) {
        this.rspHandlerFactory = rspHandlerFactory;
    }

    public AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public Connection getRemoteConnection() {
        return this.remote;
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public void setAttributes(Attributes attrs) {
        this.attrs = attrs;
    }

    public void setTmpFile(File tmpFile) {
        this.tmpFile = tmpFile;
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public final void setUIDSuffix(String uidSuffix) {
        this.uidSuffix = uidSuffix;
    }

    public final void setTmpFilePrefix(String prefix) {
        this.tmpPrefix = prefix;
    }

    public final void setTmpFileSuffix(String suffix) {
        this.tmpSuffix = suffix;
    }

    public final void setTmpFileDirectory(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public final void enableSOPClassRelationshipExtNeg(boolean enable) {
        this.relExtNeg = enable;
    }

    public void scanFiles(List<String> fnames) throws IOException {
        this.scanFiles(fnames, true);
    }

    public void scanFiles(List<String> fnames, boolean printout) throws IOException {
        this.tmpFile = File.createTempFile(this.tmpPrefix, this.tmpSuffix, this.tmpDir);
        this.tmpFile.deleteOnExit();
        try (BufferedWriter fileInfos = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.tmpFile)));){
            StoreSCU.scan(fnames, printout, (File f, Attributes fmi, long dsPos, Attributes ds) -> {
                if (!this.addFile(fileInfos, f, dsPos, fmi, ds)) {
                    return false;
                }
                ++this.filesScanned;
                return true;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendFiles() throws IOException {
        BufferedReader fileInfos = new BufferedReader(new InputStreamReader(new FileInputStream(this.tmpFile)));
        try {
            String line;
            while (this.as.isReadyForDataTransfer() && (line = fileInfos.readLine()) != null) {
                Progress p = this.state.getProgress();
                if (p != null && p.isCancel()) {
                    Logger.info("Aborting C-Store: {}", "cancel by progress");
                    this.as.abort();
                    break;
                }
                String[] ss = (String[])StringKit.split(line, '\t').toArray();
                try {
                    this.send(new File(ss[4]), Long.parseLong(ss[3]), ss[1], ss[0], ss[2]);
                }
                catch (Exception e) {
                    Logger.error("Cannot send file", e);
                }
            }
            try {
                this.as.waitForOutstandingRSP();
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Logger.error("Waiting for RSP", e);
                return;
            }
        }
        finally {
            IoKit.close(fileInfos);
        }
    }

    public boolean addFile(BufferedWriter fileInfos, File f, long endFmi, Attributes fmi, Attributes ds) throws IOException {
        String cuid = fmi.getString(131074);
        String iuid = fmi.getString(131075);
        String ts = fmi.getString(131088);
        if (cuid == null || iuid == null) {
            return false;
        }
        fileInfos.write(iuid);
        fileInfos.write(9);
        fileInfos.write(cuid);
        fileInfos.write(9);
        fileInfos.write(ts);
        fileInfos.write(9);
        fileInfos.write(Long.toString(endFmi));
        fileInfos.write(9);
        fileInfos.write(f.getPath());
        fileInfos.newLine();
        if (this.rq.containsPresentationContextFor(cuid, ts)) {
            return true;
        }
        if (!this.rq.containsPresentationContextFor(cuid)) {
            if (this.relExtNeg) {
                this.rq.addCommonExtendedNegotiation(this.relSOPClasses.getCommonExtendedNegotiation(cuid));
            }
            if (!ts.equals("1.2.840.10008.1.2.1")) {
                this.rq.addPresentationContext(new Presentation(this.rq.getNumberOfPresentationContexts() * 2 + 1, cuid, "1.2.840.10008.1.2.1"));
            }
            if (!ts.equals("1.2.840.10008.1.2")) {
                this.rq.addPresentationContext(new Presentation(this.rq.getNumberOfPresentationContexts() * 2 + 1, cuid, "1.2.840.10008.1.2"));
            }
        }
        this.rq.addPresentationContext(new Presentation(this.rq.getNumberOfPresentationContexts() * 2 + 1, cuid, ts));
        return true;
    }

    public Attributes echo() throws IOException, InterruptedException {
        DimseRSP response = this.as.cecho();
        response.next();
        return response.getCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(File f, long fmiEndPos, String cuid, String iuid, String filets) throws IOException, InterruptedException, ParserConfigurationException, SAXException {
        String ts = StoreSCU.selectTransferSyntax(this.as, cuid, filets);
        boolean noChange = this.uidSuffix == null && this.attrs.isEmpty() && ts.equals(filets) && this.attributesEditors == null;
        DataWriter dataWriter = null;
        InputStream in = null;
        Attributes data = null;
        try {
            if (f.getName().endsWith(".xml")) {
                in = new FileInputStream(f);
                data = SAXReader.parse(in);
                noChange = false;
            } else if (noChange) {
                in = new FileInputStream(f);
                in.skip(fmiEndPos);
                dataWriter = new InputStreamWriter(in);
            } else {
                in = new ImageInputStream(f);
                ((ImageInputStream)in).setIncludeBulkData(ImageInputStream.IncludeBulkData.URI);
                data = ((ImageInputStream)in).readDataset(-1, -1);
            }
            if (!noChange) {
                AttributeContext context;
                if (this.attributesEditors != null && this.attributesEditors.apply(data, context = new AttributeContext(ts, Node.buildLocalDicomNode(this.as), Node.buildRemoteDicomNode(this.as)))) {
                    iuid = data.getString(524312);
                }
                if (StoreSCU.updateAttributes(data, this.attrs, this.uidSuffix)) {
                    iuid = data.getString(524312);
                }
                if (!ts.equals(filets)) {
                    Decompressor.decompress(data, filets);
                }
                dataWriter = new DataWriterAdapter(data);
            }
            this.as.cstore(cuid, iuid, this.priority, dataWriter, ts, this.rspHandlerFactory.createDimseRSPHandler(f));
        }
        catch (Throwable throwable) {
            IoKit.close(in);
            throw throwable;
        }
        IoKit.close(in);
    }

    @Override
    public void close() throws IOException, InterruptedException {
        if (this.as != null) {
            if (this.as.isReadyForDataTransfer()) {
                this.as.release();
            }
            this.as.waitForSocketClose();
        }
    }

    public void open() throws IOException, InterruptedException, GeneralSecurityException {
        this.as = this.ae.connect(this.remote, this.rq);
    }

    private void onCStoreRSP(Attributes cmd, File f) {
        String ps;
        int status = cmd.getInt(2304, -1);
        this.state.setStatus(status);
        switch (status) {
            case 0: {
                this.totalSize += f.length();
                ps = "COMPLETED";
                break;
            }
            case 45056: 
            case 45062: 
            case 45063: {
                this.totalSize += f.length();
                ps = "WARNING";
                System.err.println(MessageFormat.format("WARNING: Received C-STORE-RSP with Status {0}H for {1}", Tag.shortToHexString(status), f));
                System.err.println(cmd);
                break;
            }
            default: {
                ps = "FAILED";
                System.err.println(MessageFormat.format("ERROR: Received C-STORE-RSP with Status {0}H for {1}", Tag.shortToHexString(status), f));
                System.err.println(cmd);
            }
        }
        Builder.notify(this.state.getProgress(), cmd, ps, this.filesScanned);
    }

    public int getFilesScanned() {
        return this.filesScanned;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public Status getState() {
        return this.state;
    }

    public class SOPClasses {
        private final HashMap<String, CommonExtended> commonExtNegs = new HashMap();

        public void init(Properties props) {
            for (String cuid : props.stringPropertyNames()) {
                this.commonExtNegs.put(cuid, new CommonExtended(cuid, "1.2.840.10008.4.2", (String[])StringKit.split(props.getProperty(cuid), ',').toArray()));
            }
        }

        public CommonExtended getCommonExtendedNegotiation(String cuid) {
            CommonExtended commonExtNeg = this.commonExtNegs.get(cuid);
            return commonExtNeg != null ? commonExtNeg : new CommonExtended(cuid, "1.2.840.10008.4.2", new String[0]);
        }
    }

    public static interface Callback {
        public boolean dicomFile(File var1, Attributes var2, long var3, Attributes var5) throws Exception;
    }

    public static interface RSPHandlerFactory {
        public DimseRSPHandler createDimseRSPHandler(File var1);
    }
}

