/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class WeiboProvider
extends AbstractProvider {
    public WeiboProvider(Context context) {
        super(context, Registry.WEIBO);
    }

    public WeiboProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.WEIBO, extendCache);
    }

    public static String getLocalIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        JSONObject object = JSONObject.parseObject((String)this.doPostAuthorizationCode(callback.getCode()));
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getString("error_description"));
        }
        return AccToken.builder().accessToken(object.getString("access_token")).uid(object.getString("uid")).openId(object.getString("uid")).expireIn(object.getIntValue("expires_in")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "OAuth2 " + String.format("uid=%s&access_token=%s", accToken.getUid(), accToken.getAccessToken()));
        header.put("API-RemoteIP", WeiboProvider.getLocalIp());
        String response = Httpx.get(this.userInfoUrl(accToken), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getString("error"));
        }
        return Property.builder().rawJson(object).uuid(object.getString("id")).username(object.getString("name")).avatar(object.getString("profile_image_url")).blog(StringKit.isEmpty(object.getString("url")) ? "https://weibo.com/" + object.getString("profile_url") : object.getString("url")).nickname(object.getString("screen_name")).location(object.getString("location")).remark(object.getString("description")).gender(Normal.Gender.getGender(object.getString("gender"))).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", accToken.getAccessToken()).queryParam("uid", accToken.getUid()).build();
    }

    @Override
    public Message revoke(AccToken accToken) {
        JSONObject object = JSONObject.parseObject((String)this.doGetRevoke(accToken));
        if (object.containsKey((Object)"error")) {
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(object.getString("error")).build();
        }
        Builder.ErrorCode status = object.getBooleanValue("result") ? Builder.ErrorCode.SUCCESS : Builder.ErrorCode.FAILURE;
        return Message.builder().errcode(status.getCode()).errmsg(status.getMsg()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, WeiboProvider.getScopes(true, OauthScope.Weibo.values()))).build();
    }
}

