/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.metric;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.aoju.bus.core.key.ObjectID;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.metric.OfficeManager;
import org.aoju.bus.office.metric.OfficeManagerBuilder;
import org.aoju.bus.office.metric.TemporaryFileMaker;

public abstract class AbstractOfficeManager
implements OfficeManager,
TemporaryFileMaker {
    protected final OfficeManagerBuilder config;
    private final AtomicLong tempFileCounter;
    private File tempDir;

    protected AbstractOfficeManager(OfficeManagerBuilder config) {
        this.config = config;
        this.tempFileCounter = new AtomicLong(0L);
    }

    protected static File makeTempDir(File workingDir) {
        File tempDir = new File(workingDir, "converter_" + ObjectID.id());
        tempDir.mkdir();
        if (!tempDir.isDirectory()) {
            throw new IllegalStateException(String.format("Cannot create temp directory: %s", tempDir));
        }
        return tempDir;
    }

    @Override
    public File makeTemporaryFile() {
        return new File(this.tempDir, "tempfile_" + this.tempFileCounter.getAndIncrement());
    }

    @Override
    public File makeTemporaryFile(String extension) {
        return new File(this.tempDir, "tempfile_" + this.tempFileCounter.getAndIncrement() + "." + extension);
    }

    protected void makeTempDir() {
        this.deleteTempDir();
        this.tempDir = AbstractOfficeManager.makeTempDir(this.config.getWorkingDir());
    }

    protected void deleteTempDir() {
        if (this.tempDir != null) {
            Logger.debug("Deleting temporary directory '{}'", this.tempDir);
            try {
                FileKit.delete(this.tempDir);
            }
            catch (InstrumentException ioEx) {
                Logger.error("Could not temporary profileDir: {}", ioEx.getMessage());
            }
        }
    }

    public static abstract class AbstractOfficeManagerBuilder<B extends AbstractOfficeManagerBuilder<B>> {
        protected boolean install;
        protected File workingDir;

        protected AbstractOfficeManagerBuilder() {
        }

        public B install() {
            this.install = true;
            return (B)this;
        }

        public B workingDir(File workingDir) {
            this.workingDir = workingDir;
            return (B)this;
        }

        public B workingDir(String workingDir) {
            return (B)(StringKit.isBlank(workingDir) ? this : this.workingDir(new File(workingDir)));
        }

        protected abstract AbstractOfficeManager build();
    }
}

