/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.CellKit;
import org.aoju.bus.office.support.excel.ExcelBase;
import org.aoju.bus.office.support.excel.ExcelKit;
import org.aoju.bus.office.support.excel.RowKit;
import org.aoju.bus.office.support.excel.StyleSet;
import org.aoju.bus.office.support.excel.WorksKit;
import org.aoju.bus.office.support.excel.cell.CellLocation;
import org.aoju.bus.office.support.excel.style.Align;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;

public class ExcelWriter
extends ExcelBase<ExcelWriter> {
    protected File destFile;
    private AtomicInteger currentRow = new AtomicInteger(0);
    private Map<String, String> headerAlias;
    private boolean onlyAlias;
    private Comparator<String> aliasComparator;
    private StyleSet styleSet = new StyleSet(this.workbook);
    private Map<String, Integer> headLocationCache;

    public ExcelWriter() {
        this(false);
    }

    public ExcelWriter(boolean isXlsx) {
        this(WorksKit.createBook(isXlsx), null);
    }

    public ExcelWriter(String destFilePath) {
        this(destFilePath, null);
    }

    public ExcelWriter(boolean isXlsx, String sheetName) {
        this(WorksKit.createBook(isXlsx), sheetName);
    }

    public ExcelWriter(String destFilePath, String sheetName) {
        this(FileKit.file(destFilePath), sheetName);
    }

    public ExcelWriter(File destFile) {
        this(destFile, null);
    }

    public ExcelWriter(File destFile, String sheetName) {
        this(destFile.exists() ? WorksKit.createBook(FileKit.getInputStream(destFile), true) : WorksKit.createBook(StringKit.endWithIgnoreCase(destFile.getName(), ".xlsx")), sheetName);
        this.destFile = destFile;
    }

    public ExcelWriter(Workbook workbook, String sheetName) {
        this(WorksKit.getOrCreateSheet(workbook, sheetName));
    }

    public ExcelWriter(Sheet sheet) {
        super(sheet);
    }

    @Override
    public ExcelWriter setSheet(int sheetIndex) {
        this.reset();
        return (ExcelWriter)super.setSheet(sheetIndex);
    }

    @Override
    public ExcelWriter setSheet(String sheetName) {
        this.reset();
        return (ExcelWriter)super.setSheet(sheetName);
    }

    public ExcelWriter reset() {
        this.resetRow();
        this.aliasComparator = null;
        this.headLocationCache = null;
        return this;
    }

    public ExcelWriter renameSheet(String sheetName) {
        return this.renameSheet(this.workbook.getSheetIndex(this.sheet), sheetName);
    }

    public ExcelWriter renameSheet(int sheet, String sheetName) {
        this.workbook.setSheetName(sheet, sheetName);
        return this;
    }

    public ExcelWriter autoSizeColumnAll() {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.autoSizeColumn(i);
        }
        return this;
    }

    public ExcelWriter autoSizeColumn(int columnIndex) {
        this.sheet.autoSizeColumn(columnIndex);
        return this;
    }

    public ExcelWriter autoSizeColumn(int columnIndex, boolean useMergedCells) {
        this.sheet.autoSizeColumn(columnIndex, useMergedCells);
        return this;
    }

    public StyleSet getStyleSet() {
        return this.styleSet;
    }

    public ExcelWriter setStyleSet(StyleSet styleSet) {
        this.styleSet = styleSet;
        return this;
    }

    public CellStyle getHeadCellStyle() {
        return this.styleSet.headCellStyle;
    }

    public CellStyle getCellStyle() {
        if (null == this.styleSet) {
            return null;
        }
        return this.styleSet.cellStyle;
    }

    public int getCurrentRow() {
        return this.currentRow.get();
    }

    public ExcelWriter setCurrentRow(int rowIndex) {
        this.currentRow.set(rowIndex);
        return this;
    }

    public ExcelWriter passCurrentRow() {
        this.currentRow.incrementAndGet();
        return this;
    }

    public ExcelWriter passRows(int rows) {
        this.currentRow.addAndGet(rows);
        return this;
    }

    public ExcelWriter resetRow() {
        this.currentRow.set(0);
        return this;
    }

    public ExcelWriter setDestFile(File destFile) {
        this.destFile = destFile;
        return this;
    }

    public ExcelWriter setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
        return this;
    }

    public ExcelWriter clearHeaderAlias() {
        this.headerAlias = null;
        return this;
    }

    public ExcelWriter setOnlyAlias(boolean isOnlyAlias) {
        this.onlyAlias = isOnlyAlias;
        return this;
    }

    public ExcelWriter addHeaderAlias(String name, String alias) {
        Map<String, String> headerAlias = this.headerAlias;
        if (null == headerAlias) {
            headerAlias = new LinkedHashMap<String, String>();
        }
        this.headerAlias = headerAlias;
        headerAlias.put(name, alias);
        return this;
    }

    public ExcelWriter setFreezePane(int rowSplit) {
        return this.setFreezePane(0, rowSplit);
    }

    public ExcelWriter setFreezePane(int colSplit, int rowSplit) {
        this.getSheet().createFreezePane(colSplit, rowSplit);
        return this;
    }

    public ExcelWriter setColumnWidth(int columnIndex, int width) {
        if (columnIndex < 0) {
            this.sheet.setDefaultColumnWidth(width);
        } else {
            this.sheet.setColumnWidth(columnIndex, width * 256);
        }
        return this;
    }

    public ExcelWriter setRowHeight(int rownum, int height) {
        if (rownum < 0) {
            this.sheet.setDefaultRowHeightInPoints((float)height);
        } else {
            Row row = this.sheet.getRow(rownum);
            if (null != row) {
                row.setHeightInPoints((float)height);
            }
        }
        return this;
    }

    public ExcelWriter setHeaderOrFooter(String text, Align align, boolean isFooter) {
        Footer headerFooter = isFooter ? this.sheet.getFooter() : this.sheet.getHeader();
        switch (align) {
            case LEFT: {
                headerFooter.setLeft(text);
                break;
            }
            case RIGHT: {
                headerFooter.setRight(text);
                break;
            }
            case CENTER: {
                headerFooter.setCenter(text);
                break;
            }
        }
        return this;
    }

    public ExcelWriter merge(int lastColumn) {
        return this.merge(lastColumn, null);
    }

    public ExcelWriter merge(int lastColumn, Object content) {
        return this.merge(lastColumn, content, true);
    }

    public ExcelWriter merge(int lastColumn, Object content, boolean isSetHeaderStyle) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        int rowIndex = this.currentRow.get();
        this.merge(rowIndex, rowIndex, 0, lastColumn, content, isSetHeaderStyle);
        if (null != content) {
            this.currentRow.incrementAndGet();
        }
        return this;
    }

    public ExcelWriter merge(int firstRow, int lastRow, int firstColumn, int lastColumn, Object content, boolean isSetHeaderStyle) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        CellStyle style = isSetHeaderStyle && null != this.styleSet && null != this.styleSet.headCellStyle ? this.styleSet.headCellStyle : this.styleSet.cellStyle;
        CellKit.mergingCells(this.sheet, firstRow, lastRow, firstColumn, lastColumn, style);
        if (null != content) {
            Cell cell = this.getOrCreateCell(firstColumn, firstRow);
            CellKit.setCellValue(cell, content, this.styleSet, isSetHeaderStyle);
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data) {
        return this.write(data, 0 == this.getCurrentRow());
    }

    public ExcelWriter write(Iterable<?> data, boolean isWriteKeyAsHead) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        boolean isFirst = true;
        for (Object object : data) {
            this.writeRow(object, isFirst && isWriteKeyAsHead);
            if (!isFirst) continue;
            isFirst = false;
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data, Comparator<String> comparator) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        boolean isFirstRow = true;
        for (Object obj : data) {
            Map<String, Object> map;
            if (obj instanceof Map) {
                map = new TreeMap(comparator);
                map.putAll((Map)obj);
            } else {
                map = BeanKit.beanToMap(obj, new TreeMap<String, Object>(comparator), false, false);
            }
            this.writeRow(map, isFirstRow);
            if (!isFirstRow) continue;
            isFirstRow = false;
        }
        return this;
    }

    public ExcelWriter writeHeadRow(Iterable<?> rowData) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        this.headLocationCache = new ConcurrentHashMap<String, Integer>();
        Row row = this.sheet.createRow(this.currentRow.getAndIncrement());
        int i = 0;
        for (Object value : rowData) {
            Cell cell = row.createCell(i);
            CellKit.setCellValue(cell, value, this.styleSet, true);
            this.headLocationCache.put(StringKit.toString(value), i);
            ++i;
        }
        return this;
    }

    public ExcelWriter writeRow(Object rowBean, boolean isWriteKeyAsHead) {
        Map<String, Object> rowMap;
        if (rowBean instanceof Iterable) {
            return this.writeRow((Iterable)rowBean);
        }
        if (rowBean instanceof Map) {
            rowMap = MapKit.isNotEmpty(this.headerAlias) ? MapKit.newTreeMap((Map)rowBean, this.getCachedAliasComparator()) : (TreeMap)rowBean;
        } else if (BeanKit.isBean(rowBean.getClass())) {
            rowMap = MapKit.isEmpty(this.headerAlias) ? BeanKit.beanToMap(rowBean, new LinkedHashMap<String, Object>(), false, false) : BeanKit.beanToMap(rowBean, new TreeMap<String, Object>(this.getCachedAliasComparator()), false, false);
        } else {
            return this.writeRow(CollKit.newArrayList(rowBean), isWriteKeyAsHead);
        }
        return this.writeRow(rowMap, isWriteKeyAsHead);
    }

    public ExcelWriter writeRow(Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        if (MapKit.isEmpty(rowMap)) {
            return this.passCurrentRow();
        }
        Map<?, ?> aliasMap = this.aliasMap(rowMap);
        if (isWriteKeyAsHead) {
            this.writeHeadRow(aliasMap.keySet());
        }
        if (MapKit.isNotEmpty(this.headLocationCache)) {
            Row row = RowKit.getOrCreateRow(this.sheet, this.currentRow.getAndIncrement());
            for (Map.Entry<?, ?> entry : aliasMap.entrySet()) {
                Integer location = this.headLocationCache.get(StringKit.toString(entry.getKey()));
                if (null == location) continue;
                CellKit.setCellValue(CellKit.getOrCreateCell(row, location), entry.getValue(), this.styleSet, false);
            }
        } else {
            this.writeRow(aliasMap.values());
        }
        return this;
    }

    public ExcelWriter writeRow(Iterable<?> rowData) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        RowKit.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.styleSet, false);
        return this;
    }

    public ExcelWriter writeCellValue(int x, int y, Object value) {
        Cell cell = this.getOrCreateCell(x, y);
        CellKit.setCellValue(cell, value, this.styleSet, false);
        return this;
    }

    public ExcelWriter writeCellValue(String locationRef, Object value) {
        CellLocation cellLocation = ExcelKit.toLocation(locationRef);
        return this.writeCellValue(cellLocation.getX(), cellLocation.getY(), value);
    }

    public ExcelWriter setStyle(CellStyle style, int x, int y) {
        Cell cell = this.getOrCreateCell(x, y);
        cell.setCellStyle(style);
        return this;
    }

    public ExcelWriter setStyle(CellStyle style, String locationRef) {
        CellLocation cellLocation = ExcelKit.toLocation(locationRef);
        return this.setStyle(style, cellLocation.getX(), cellLocation.getY());
    }

    public ExcelWriter setRowStyle(int y, CellStyle style) {
        this.getOrCreateRow(y).setRowStyle(style);
        return this;
    }

    public Font createFont() {
        return this.getWorkbook().createFont();
    }

    public ExcelWriter flush() throws InstrumentException {
        return this.flush(this.destFile);
    }

    public ExcelWriter flush(File destFile) throws InstrumentException {
        Assert.notNull(destFile, "[destFile] is null, and you must call setDestFile(File) first or call flush(OutputStream).", new Object[0]);
        return this.flush(FileKit.getOutputStream(destFile), true);
    }

    public ExcelWriter flush(OutputStream out) throws InstrumentException {
        return this.flush(out, false);
    }

    public ExcelWriter flush(OutputStream out, boolean isCloseOut) throws InstrumentException {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        try {
            this.workbook.write(out);
            out.flush();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            if (isCloseOut) {
                IoKit.close(out);
            }
        }
        return this;
    }

    public ExcelWriter addSelect(int x, int y, String ... selectList) {
        return this.addSelect(new CellRangeAddressList(y, y, x, x), selectList);
    }

    public ExcelWriter addSelect(CellRangeAddressList regions, String ... selectList) {
        DataValidationConstraint constraint;
        DataValidationHelper validationHelper = this.sheet.getDataValidationHelper();
        DataValidation dataValidation = validationHelper.createValidation(constraint = validationHelper.createExplicitListConstraint(selectList), regions);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        return this.addValidationData(dataValidation);
    }

    public ExcelWriter addValidationData(DataValidation dataValidation) {
        this.sheet.addValidationData(dataValidation);
        return this;
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        this.closeWithoutFlush();
    }

    protected void closeWithoutFlush() {
        super.close();
        this.currentRow = null;
        this.styleSet = null;
    }

    private Map<?, ?> aliasMap(Map<?, ?> rowMap) {
        if (MapKit.isEmpty(this.headerAlias)) {
            return rowMap;
        }
        HashMap<String, ?> filteredMap = MapKit.newHashMap(rowMap.size(), true);
        for (Map.Entry<?, ?> entry : rowMap.entrySet()) {
            String aliasName = this.headerAlias.get(entry.getKey());
            if (null != aliasName) {
                filteredMap.put(aliasName, entry.getValue());
                continue;
            }
            if (this.onlyAlias) continue;
            filteredMap.put((String)entry.getKey(), entry.getValue());
        }
        return filteredMap;
    }

    private Comparator<String> getCachedAliasComparator() {
        if (MapKit.isEmpty(this.headerAlias)) {
            return null;
        }
        Comparator<String> aliasComparator = this.aliasComparator;
        if (null == aliasComparator) {
            Set<String> keySet = this.headerAlias.keySet();
            this.aliasComparator = aliasComparator = new IndexedComparator<String>(keySet.toArray(new String[keySet.size()]));
        }
        return aliasComparator;
    }

    class IndexedComparator<T>
    implements Comparator<T> {
        private final T[] array;

        public IndexedComparator(T ... objs) {
            this.array = objs;
        }

        @Override
        public int compare(T o1, T o2) {
            int index2;
            int index1 = ArrayKit.indexOf(this.array, o1);
            if (index1 == (index2 = ArrayKit.indexOf(this.array, o2))) {
                return this.compare(o1, o2, true);
            }
            return index1 < index2 ? -1 : 1;
        }

        @Override
        public <T extends Comparable<? super T>> int compare(T c1, T c2) {
            return this.compare(c1, c2, false);
        }

        public <T extends Comparable<? super T>> int compare(T c1, T c2, boolean isNullGreater) {
            if (c1 == c2) {
                return 0;
            }
            if (c1 == null) {
                return isNullGreater ? 1 : -1;
            }
            if (c2 == null) {
                return isNullGreater ? -1 : 1;
            }
            return c1.compareTo(c2);
        }

        public <T> int compare(T o1, T o2, boolean isNullGreater) {
            if (o1 == o2) {
                return 0;
            }
            if (null == o1) {
                return isNullGreater ? 1 : -1;
            }
            if (null == o2) {
                return isNullGreater ? -1 : 1;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            if (o1.equals(o2)) {
                return 0;
            }
            int result = Integer.compare(o1.hashCode(), o2.hashCode());
            if (0 == result) {
                result = this.compare(o1.toString(), o2.toString());
            }
            return result;
        }
    }
}

