/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel.sax;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.ExcelSaxKit;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SheetSaxReader
extends DefaultHandler {
    private static final String TAG_NAME = "sheet";
    private static final String RID_ATTR = "r:id";
    private static final String SHEET_ID_ATTR = "sheetId";
    private static final String NAME_ATTR = "name";
    private final Map<String, String> ID_RID_MAP = new HashMap<String, String>();
    private final Map<String, String> NAME_RID_MAP = new HashMap<String, String>();

    public SheetSaxReader read(XSSFReader xssfReader) {
        InputStream workbookData = null;
        try {
            workbookData = xssfReader.getWorkbookData();
            ExcelSaxKit.readFrom(workbookData, this);
        }
        catch (IOException | InvalidFormatException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoKit.close(workbookData);
        }
        return this;
    }

    public String getRidBySheetId(String sheetId) {
        return this.ID_RID_MAP.get(sheetId);
    }

    public String getRidByName(String sheetName) {
        return this.NAME_RID_MAP.get(sheetName);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (TAG_NAME.equalsIgnoreCase(localName)) {
            int length = attributes.getLength();
            String sheetId = null;
            String rid = null;
            String name = null;
            for (int i = 0; i < length; ++i) {
                switch (attributes.getLocalName(i)) {
                    case "sheetId": {
                        sheetId = attributes.getValue(i);
                        break;
                    }
                    case "r:id": {
                        rid = attributes.getValue(i);
                        break;
                    }
                    case "name": {
                        name = attributes.getValue(i);
                    }
                }
                if (StringKit.isNotEmpty(sheetId)) {
                    this.ID_RID_MAP.put(sheetId, rid);
                }
                if (!StringKit.isNotEmpty(name)) continue;
                this.NAME_RID_MAP.put(name, rid);
            }
        }
    }
}

