/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.beans;

import org.aoju.bus.shade.beans.ColumnType;
import org.aoju.bus.shade.beans.DateType;
import org.aoju.bus.shade.beans.MySQLColumnType;
import org.aoju.bus.shade.beans.TypeConvert;

public class MySQLTypeConvert
implements TypeConvert {
    @Override
    public ColumnType processTypeConvert(DateType dateType, String fieldType) {
        String t = fieldType.toLowerCase();
        if (t.contains("char")) {
            return MySQLColumnType.STRING;
        }
        if (t.contains("bigint")) {
            return MySQLColumnType.LONG;
        }
        if (t.contains("tinyint(1)")) {
            return MySQLColumnType.BOOLEAN;
        }
        if (t.contains("int")) {
            return MySQLColumnType.INTEGER;
        }
        if (t.contains("text")) {
            return MySQLColumnType.STRING;
        }
        if (t.contains("bit")) {
            return MySQLColumnType.BOOLEAN;
        }
        if (t.contains("decimal")) {
            return MySQLColumnType.BIG_DECIMAL;
        }
        if (t.contains("clob")) {
            return MySQLColumnType.CLOB;
        }
        if (t.contains("blob")) {
            return MySQLColumnType.BLOB;
        }
        if (t.contains("binary")) {
            return MySQLColumnType.BYTE_ARRAY;
        }
        if (t.contains("float")) {
            return MySQLColumnType.FLOAT;
        }
        if (t.contains("double")) {
            return MySQLColumnType.DOUBLE;
        }
        if (t.contains("json") || t.contains("enum")) {
            return MySQLColumnType.STRING;
        }
        if (t.contains("date") || t.contains("time") || t.contains("year")) {
            switch (dateType) {
                case ONLY_DATE: {
                    return MySQLColumnType.DATE;
                }
                case SQL_PACK: {
                    switch (t) {
                        case "date": {
                            return MySQLColumnType.DATE_SQL;
                        }
                        case "time": {
                            return MySQLColumnType.TIME;
                        }
                        case "year": {
                            return MySQLColumnType.DATE_SQL;
                        }
                    }
                    return MySQLColumnType.TIMESTAMP;
                }
                case TIME_PACK: {
                    switch (t) {
                        case "date": {
                            return MySQLColumnType.LOCAL_DATE;
                        }
                        case "time": {
                            return MySQLColumnType.LOCAL_TIME;
                        }
                        case "year": {
                            return MySQLColumnType.YEAR;
                        }
                    }
                    return MySQLColumnType.LOCAL_DATE_TIME;
                }
            }
        }
        return MySQLColumnType.STRING;
    }
}

