/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.shade.screw.dialect.DatabaseQuery;
import org.aoju.bus.shade.screw.dialect.DatabaseType;
import org.aoju.bus.shade.screw.metadata.Column;
import org.aoju.bus.shade.screw.metadata.PrimaryKey;

public abstract class AbstractDatabaseQuery
implements DatabaseQuery {
    protected final Map<String, List<Column>> columnsCaching = new ConcurrentHashMap<String, List<Column>>();
    private final DataSource dataSource;
    protected volatile Connection connection;

    public AbstractDatabaseQuery(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static void close(ResultSet rs) {
        if (!Objects.isNull(rs)) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new InstrumentException(e);
            }
        }
    }

    public static void close(Connection conn) {
        if (!Objects.isNull(conn)) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new InstrumentException(e);
            }
        }
    }

    public static void close(ResultSet rs, Connection conn) {
        if (!Objects.isNull(rs)) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new InstrumentException(e);
            }
        }
        if (!Objects.isNull(conn)) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new InstrumentException(e);
            }
        }
    }

    public static void close(ResultSet rs, Statement st, Connection conn) {
        if (!Objects.isNull(rs)) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new InstrumentException(e);
            }
        }
        if (!Objects.isNull(st)) {
            try {
                st.close();
            }
            catch (SQLException e) {
                throw new InstrumentException(e);
            }
        }
        if (!Objects.isNull(conn)) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new InstrumentException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws InstrumentException {
        try {
            if (!Objects.isNull(this.connection) && !this.connection.isClosed()) {
                return this.connection;
            }
            Class<AbstractDatabaseQuery> clazz = AbstractDatabaseQuery.class;
            synchronized (AbstractDatabaseQuery.class) {
                if (Objects.isNull(this.connection) || this.connection.isClosed()) {
                    this.connection = this.getDataSource().getConnection();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.connection;
            }
        }
        catch (SQLException e) {
            throw new InstrumentException(e);
        }
    }

    protected String getCatalog() throws InstrumentException {
        try {
            String catalog = this.getConnection().getCatalog();
            if (StringKit.isBlank(catalog)) {
                return null;
            }
            return catalog;
        }
        catch (SQLException e) {
            throw new InstrumentException(e);
        }
    }

    protected String getSchema() throws InstrumentException {
        try {
            String url = this.getDataSource().getConnection().getMetaData().getURL();
            String name = DatabaseType.getDbType(url).getName();
            String schema = DatabaseType.CACHEDB.getName().equals(name) ? this.verifySchema(this.getDataSource()) : this.getConnection().getSchema();
            if (StringKit.isBlank(schema)) {
                return null;
            }
            return schema;
        }
        catch (SQLException e) {
            throw new InstrumentException(e);
        }
    }

    private String verifySchema(DataSource dataSource) throws SQLException {
        String schema = dataSource.getConnection().getSchema();
        ResultSet resultSet = this.getConnection().getMetaData().getSchemas();
        while (resultSet.next()) {
            int columnCount = resultSet.getMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnValue = resultSet.getString(i);
                if (!StringKit.isNotBlank(columnValue) || !columnValue.contains(schema)) continue;
                return schema;
            }
        }
        return null;
    }

    protected DatabaseMetaData getMetaData() throws InstrumentException {
        try {
            return this.getConnection().getMetaData();
        }
        catch (SQLException e) {
            throw new InstrumentException(e);
        }
    }

    protected PreparedStatement prepareStatement(String sql) throws InstrumentException {
        Assert.notEmpty(sql, "Sql can not be empty!", new Object[0]);
        try {
            return this.getConnection().prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws InstrumentException {
        throw new InstrumentException("Not supported yet!");
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

