/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.mapping;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.shade.screw.mapping.FieldMethod;
import org.aoju.bus.shade.screw.mapping.MappingField;

public class Mapping {
    private Mapping() {
    }

    public static <T> T convert(ResultSet resultSet, Class<T> clazz) throws InstrumentException {
        HashMap<String, Object> values = new HashMap<String, Object>(16);
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (resultSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = metaData.getColumnName(i);
                    values.put(columnName, resultSet.getString(columnName));
                }
            }
            if (values.size() != 0) {
                List<FieldMethod> fieldMethods = Mapping.getFieldMethods(clazz);
                return Mapping.getObject(clazz, fieldMethods, values);
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> List<T> convertList(ResultSet resultSet, Class<T> clazz) throws InstrumentException {
        ArrayList values = new ArrayList(16);
        ArrayList<T> list = new ArrayList<T>();
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (resultSet.next()) {
                HashMap<String, String> value = new HashMap<String, String>(16);
                for (int i = 1; i <= columnCount; ++i) {
                    String string = metaData.getColumnName(i);
                    value.put(string, resultSet.getString(i));
                }
                values.add(value);
            }
            List<FieldMethod> fieldMethods = Mapping.getFieldMethods(clazz);
            for (Map map : values) {
                T rsp = Mapping.getObject(clazz, fieldMethods, map);
                list.add(rsp);
            }
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        return list;
    }

    private static <T> T getObject(Class<T> clazz, List<FieldMethod> fieldMethods, Map<String, Object> map) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        T rsp = clazz.newInstance();
        for (FieldMethod filed : fieldMethods) {
            Field field = filed.getField();
            Method method = filed.getMethod();
            MappingField jsonField = field.getAnnotation(MappingField.class);
            if (Objects.isNull(jsonField)) continue;
            method.invoke(rsp, map.get(jsonField.value()));
        }
        return rsp;
    }

    private static <T> List<FieldMethod> getFieldMethods(Class<T> clazz) throws IntrospectionException, NoSuchFieldException {
        PropertyDescriptor[] pds;
        ArrayList<FieldMethod> fieldMethods = new ArrayList<FieldMethod>();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
            Method writeMethod = pd.getWriteMethod();
            if (writeMethod == null) continue;
            Field field = clazz.getDeclaredField(pd.getName());
            FieldMethod fieldMethod = new FieldMethod();
            fieldMethod.setField(field);
            fieldMethod.setMethod(writeMethod);
            fieldMethods.add(fieldMethod);
        }
        return fieldMethods;
    }

    private static Field tryGetFieldWithoutExp(Class<?> clazz, String itemName) {
        try {
            return clazz.getDeclaredField(itemName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <T> Method tryGetSetMethod(Class<T> clazz, Field field, String methodName) {
        try {
            return clazz.getDeclaredMethod(methodName, field.getType());
        }
        catch (Exception e) {
            return null;
        }
    }
}

