/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.goalie.filter;

import com.alibaba.fastjson.JSON;
import org.aoju.bus.base.entity.Message;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.goalie.reactor.ExchangeContext;
import org.aoju.bus.starter.goalie.GoalieProperties;
import org.aoju.bus.starter.goalie.ReactorConfiguration;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
@ConditionalOnBean(value={ReactorConfiguration.class})
@Order(value=0x7FFFFFFE)
public class EncryptFilter
implements WebFilter {
    @Autowired
    GoalieProperties.Server.Encrypt encrypt;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Mono mono = chain.filter(exchange);
        if (this.encrypt.isEnabled()) {
            return mono.then(Mono.defer(() -> {
                boolean isSign = ExchangeContext.get(exchange).getAsset().isSign();
                Flux<DataBuffer> body = ExchangeContext.get(exchange).getBody();
                return Mono.from(body).flatMap(dataBuffer -> {
                    if (isSign && dataBuffer instanceof Message) {
                        Message message = (Message)dataBuffer;
                        this.doEncrypt(message);
                        ServerHttpResponse response = exchange.getResponse();
                        return response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(JSON.toJSONString((Object)message).getBytes())));
                    }
                    return mono;
                });
            }));
        }
        return mono;
    }

    private void doEncrypt(Message message) {
        if (ObjectKit.isNotNull(message.getData())) {
            message.setData(Builder.encrypt(this.encrypt.getType(), this.encrypt.getKey(), JSON.toJSONString((Object)message.getData()), Charset.UTF_8));
        }
    }
}

