/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.goalie.filter;

import java.util.Objects;
import org.aoju.bus.goalie.reactor.ExchangeContext;
import org.aoju.bus.starter.goalie.ReactorConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
@ConditionalOnBean(value={ReactorConfiguration.class})
@Order(value=-2147483648)
public class FirstFilter
implements WebFilter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        if (Objects.equals(request.getMethod(), HttpMethod.GET)) {
            MultiValueMap params2 = request.getQueryParams();
            ExchangeContext.get(exchange).setRequestMap(params2.toSingleValueMap());
            return chain.filter(exchange);
        }
        return exchange.getFormData().flatMap(params -> {
            ExchangeContext.get(exchange).setRequestMap(params.toSingleValueMap());
            return chain.filter(exchange);
        });
    }
}

