/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.notify;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.Provider;
import org.aoju.bus.notify.Registry;
import org.aoju.bus.notify.provider.aliyun.AliyunSmsProvider;
import org.aoju.bus.notify.provider.aliyun.AliyunVmsProvider;
import org.aoju.bus.notify.provider.dingtalk.DingTalkProvider;
import org.aoju.bus.notify.provider.netease.NeteaseSmsProvider;
import org.aoju.bus.starter.notify.NotifyProperties;

public class NotifyProviderService {
    private static Map<Registry, Context> CACHE = new ConcurrentHashMap<Registry, Context>();
    public NotifyProperties properties;

    public NotifyProviderService(NotifyProperties properties) {
        this.properties = properties;
    }

    public static void register(Registry registry, Context context) {
        if (CACHE.containsKey((Object)registry)) {
            throw new InstrumentException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + registry.name());
        }
        CACHE.putIfAbsent(registry, context);
    }

    public Provider require(Registry registry) {
        Context context = CACHE.get((Object)registry);
        if (ObjectKit.isEmpty((Object)context)) {
            context = this.properties.getType().get((Object)registry);
        }
        if (Registry.ALIYUN_SMS.equals((Object)registry)) {
            return new AliyunSmsProvider(context);
        }
        if (Registry.ALIYUN_VMS.equals((Object)registry)) {
            return new AliyunVmsProvider(context);
        }
        if (Registry.DINGTALK_MSG.equals((Object)registry)) {
            return new DingTalkProvider(context);
        }
        if (Registry.NETEASE_MSG.equals((Object)registry)) {
            return new NeteaseSmsProvider(context);
        }
        throw new InstrumentException(Builder.ErrorCode.UNSUPPORTED.getMsg());
    }
}

