/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2020 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 *                                                                               *
 ********************************************************************************/
package org.aoju.bus.core.annotation;

import org.aoju.bus.core.lang.Normal;

import java.lang.annotation.*;

/**
 * 定时任务注解
 *
 * @author Kimi Liu
 * @version 6.1.3
 * @since JDK 1.8+
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Scheduled {

    /**
     * cron
     *
     * @return cron
     */
    String cron() default Normal.EMPTY;

    /**
     * 固定延迟 结束时间-开始时间
     * 单位毫秒
     *
     * @return 延迟
     */
    String fixedDelay() default Normal.EMPTY;

    /**
     * 固定周期 开始时间-开始时间
     * <p>
     * 单位毫秒
     *
     * @return 周期
     */
    String fixedRate() default Normal.EMPTY;

    /**
     * 第一次启动延迟
     * <p>
     * 单位毫秒
     *
     * @return 延迟
     */
    String initialDelay() default Normal.EMPTY;

    /**
     * 项目启动执行
     *
     * @return true为执行
     */
    boolean onApplicationStart() default false;

    /**
     * 是否异步
     * <p>
     * 只对 onApplicationStart 方式有效
     *
     * @return true为异步
     */
    boolean async() default false;

}