/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.streams;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class StringOutputStream
extends OutputStream {
    private final StringBuilder sb;
    private final String charset;
    private ByteArrayOutputStream baos;

    public StringOutputStream(StringBuilder sb) {
        this(sb, "UTF-8");
    }

    public StringOutputStream(StringBuilder sb, String charset) {
        this.sb = sb;
        this.baos = new ByteArrayOutputStream();
        this.charset = charset;
    }

    @Override
    public void write(int b) throws IOException {
        if (null == this.baos) {
            throw new IOException("Stream is closed");
        }
        this.baos.write(b);
    }

    @Override
    public void flush() throws IOException {
        if (null != this.baos) {
            this.baos.flush();
            if (this.baos.size() > 0) {
                if (this.charset == null) {
                    this.sb.append(new String(this.baos.toByteArray()));
                } else {
                    this.sb.append(new String(this.baos.toByteArray(), this.charset));
                }
                this.baos.reset();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.baos = null;
    }

    public StringBuilder getStringBuilder() {
        return this.sb;
    }
}

