/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.Validator;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;

public class CitizenIdKit {
    private static final int CHINA_ID_MIN_LENGTH = 15;
    private static final int CHINA_ID_MAX_LENGTH = 18;
    private static final int[] WEIGHTING = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final Map<String, String> AREA_CODE = new HashMap<String, String>();
    private static final Map<String, Integer> AREA_TW_CODE = new HashMap<String, Integer>();

    public static boolean isValidCard(String idcard) {
        idcard = idcard.trim();
        int length = idcard.length();
        switch (length) {
            case 18: {
                return CitizenIdKit.isValidCard18(idcard);
            }
            case 15: {
                return CitizenIdKit.isValidCard15(idcard);
            }
            case 10: {
                String[] cardVal = CitizenIdKit.isValidCard10(idcard);
                return null != cardVal && "true".equals(cardVal[2]);
            }
        }
        return false;
    }

    public static boolean isValidCard18(String idcard) {
        if (18 != idcard.length()) {
            return false;
        }
        String proCode = idcard.substring(0, 2);
        if (null == AREA_CODE.get(proCode)) {
            return false;
        }
        if (!Validator.isBirthday(idcard.substring(6, 14))) {
            return false;
        }
        String code17 = idcard.substring(0, 17);
        char code18 = Character.toLowerCase(idcard.charAt(17));
        if (PatternKit.isMatch(RegEx.NUMBERS, (CharSequence)code17)) {
            char val = CitizenIdKit.getCheckCode18(code17);
            return val == code18;
        }
        return false;
    }

    public static boolean isValidCard15(String idcard) {
        if (15 != idcard.length()) {
            return false;
        }
        if (PatternKit.isMatch(RegEx.NUMBERS, (CharSequence)idcard)) {
            String proCode = idcard.substring(0, 2);
            if (null == AREA_CODE.get(proCode)) {
                return false;
            }
            return false != Validator.isBirthday("19" + idcard.substring(6, 12));
        }
        return false;
    }

    public static String[] isValidCard10(String idcard) {
        if (StringKit.isBlank(idcard)) {
            return null;
        }
        String[] info = new String[3];
        String card = idcard.replaceAll("[()]", "");
        if (card.length() != 8 && card.length() != 9 && idcard.length() != 10) {
            return null;
        }
        if (idcard.matches("^[a-zA-Z][0-9]{9}$")) {
            info[0] = "\u53f0\u6e7e";
            char char2 = idcard.charAt(1);
            if ('1' == char2) {
                info[1] = "M";
            } else if ('2' == char2) {
                info[1] = "F";
            } else {
                info[1] = "N";
                info[2] = "false";
                return info;
            }
            info[2] = CitizenIdKit.isValidTWCard(idcard) ? "true" : "false";
        } else if (idcard.matches("^[157][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            info[0] = "\u6fb3\u95e8";
            info[1] = "N";
        } else if (idcard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            info[0] = "\u9999\u6e2f";
            info[1] = "N";
            info[2] = CitizenIdKit.isValidHKCard(idcard) ? "true" : "false";
        } else {
            return null;
        }
        return info;
    }

    public static boolean isValidTWCard(String idcard) {
        if (StringKit.isEmpty(idcard)) {
            return false;
        }
        String start = idcard.substring(0, 1);
        Integer iStart = AREA_TW_CODE.get(start);
        if (null == iStart) {
            return false;
        }
        String mid = idcard.substring(1, 9);
        String end = idcard.substring(9, 10);
        int sum = iStart / 10 + iStart % 10 * 9;
        char[] chars = mid.toCharArray();
        int iflag = 8;
        for (char c : chars) {
            sum += Integer.parseInt(String.valueOf(c)) * iflag;
            --iflag;
        }
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.parseInt(end);
    }

    public static boolean isValidHKCard(String idcard) {
        int sum;
        String card = idcard.replaceAll("[()]", "");
        if (card.length() == 9) {
            sum = (Character.toUpperCase(card.charAt(0)) - 55) * 9 + (Character.toUpperCase(card.charAt(1)) - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (Character.toUpperCase(card.charAt(0)) - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        int iflag = 7;
        for (char c : chars) {
            sum += Integer.parseInt(String.valueOf(c)) * iflag;
            --iflag;
        }
        sum = "A".equalsIgnoreCase(end) ? (sum += 10) : (sum += Integer.parseInt(end));
        return sum % 11 == 0;
    }

    public static String getBirthByIdCard(String idcard) {
        Assert.notBlank(idcard, "id card must be not blank!", new Object[0]);
        int len = idcard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idcard = CitizenIdKit.getIdCardTo18(idcard);
        }
        return Objects.requireNonNull(idcard).substring(6, 14);
    }

    public static int getAgeByIdCard(String idcard) {
        return CitizenIdKit.getAgeByIdCard(idcard, DateKit.date());
    }

    public static int getAgeByIdCard(String idcard, Date dateToCompare) {
        return DateKit.getAge(DateKit.parse(CitizenIdKit.getBirthByIdCard(idcard), "yyyyMMdd"), dateToCompare);
    }

    public static Short getYearByIdCard(String idcard) {
        int len = idcard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idcard = CitizenIdKit.getIdCardTo18(idcard);
        }
        return Short.valueOf(Objects.requireNonNull(idcard).substring(6, 10));
    }

    public static Short getMonthByIdCard(String idcard) {
        int len = idcard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idcard = CitizenIdKit.getIdCardTo18(idcard);
        }
        return Short.valueOf(Objects.requireNonNull(idcard).substring(10, 12));
    }

    public static Short getDayByIdCard(String idcard) {
        int len = idcard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idcard = CitizenIdKit.getIdCardTo18(idcard);
        }
        return Short.valueOf(Objects.requireNonNull(idcard).substring(12, 14));
    }

    public static int getGenderByIdCard(String idcard) {
        char sCardChar;
        Assert.notBlank(idcard);
        int len = idcard.length();
        if (len < 15) {
            throw new IllegalArgumentException("ID Card length must be 15 or 18");
        }
        if (len == 15) {
            idcard = CitizenIdKit.getIdCardTo18(idcard);
        }
        return (sCardChar = Objects.requireNonNull(idcard).charAt(16)) % 2 != 0 ? 1 : 0;
    }

    public static String getProvinceByIdCard(String idcard) {
        int len = idcard.length();
        if (len == 15 || len == 18) {
            String province = idcard.substring(0, 2);
            return AREA_CODE.get(province) + "," + idcard.substring(0, 5);
        }
        return null;
    }

    public static String hide(String idcard, int startInclude, int endExclude) {
        return StringKit.hide(idcard, startInclude, endExclude);
    }

    public static String getIdCardTo18(String idcard) {
        int sYear;
        if (idcard.length() != 15) {
            return null;
        }
        if (PatternKit.isMatch(RegEx.NUMBERS, (CharSequence)idcard)) {
            String birthday = idcard.substring(6, 12);
            DateTime birthDate = DateKit.parse(birthday, "yyMMdd");
            sYear = DateKit.year(birthDate);
            if (sYear > 2000) {
                sYear -= 100;
            }
        } else {
            return null;
        }
        StringBuilder idcard18 = StringKit.builder().append(idcard, 0, 6).append(sYear).append(idcard.substring(8));
        char sVal = CitizenIdKit.getCheckCode18(idcard18.toString());
        idcard18.append(sVal);
        return idcard18.toString();
    }

    private static char getCheckCode18(String code17) {
        int sum = CitizenIdKit.getPowerSum(code17.toCharArray());
        return CitizenIdKit.getCheckCode18(sum);
    }

    private static char getCheckCode18(int iSum) {
        switch (iSum % 11) {
            case 10: {
                return '2';
            }
            case 9: {
                return '3';
            }
            case 8: {
                return '4';
            }
            case 7: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 5: {
                return '7';
            }
            case 4: {
                return '8';
            }
            case 3: {
                return '9';
            }
            case 2: {
                return 'x';
            }
            case 1: {
                return '0';
            }
            case 0: {
                return '1';
            }
        }
        return ' ';
    }

    private static int getPowerSum(char[] iArr) {
        int iSum = 0;
        if (WEIGHTING.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                iSum += Integer.parseInt(String.valueOf(iArr[i])) * WEIGHTING[i];
            }
        }
        return iSum;
    }

    public CitizenInfo getCitizenInfo(String idcard) {
        CitizenInfo citizenInfo = new CitizenInfo();
        if (CitizenIdKit.isValidCard(idcard)) {
            short year = CitizenIdKit.getYearByIdCard(idcard);
            short month = CitizenIdKit.getMonthByIdCard(idcard);
            short day = CitizenIdKit.getDayByIdCard(idcard);
            citizenInfo.setVerify(CitizenIdKit.isValidCard(idcard));
            citizenInfo.setBirthDate(CitizenIdKit.getBirthByIdCard(idcard));
            citizenInfo.setAge(CitizenIdKit.getAgeByIdCard(idcard));
            citizenInfo.setProvince(CitizenIdKit.getProvinceByIdCard(idcard));
            citizenInfo.setBirthYear(year);
            citizenInfo.setBirthMonth(month);
            citizenInfo.setBirthDay(day);
            citizenInfo.setGender(Normal.Gender.getGender("" + CitizenIdKit.getGenderByIdCard(idcard)).getDesc());
            citizenInfo.setZodiac(DateKit.getZodiac(month, (int)day));
            citizenInfo.setAnimal(DateKit.getAnimal(year));
        } else {
            citizenInfo.setVerify(false);
        }
        return citizenInfo;
    }

    static {
        AREA_CODE.put("11", "\u5317\u4eac");
        AREA_CODE.put("12", "\u5929\u6d25");
        AREA_CODE.put("13", "\u6cb3\u5317");
        AREA_CODE.put("14", "\u5c71\u897f");
        AREA_CODE.put("15", "\u5185\u8499\u53e4");
        AREA_CODE.put("21", "\u8fbd\u5b81");
        AREA_CODE.put("22", "\u5409\u6797");
        AREA_CODE.put("23", "\u9ed1\u9f99\u6c5f");
        AREA_CODE.put("31", "\u4e0a\u6d77");
        AREA_CODE.put("32", "\u6c5f\u82cf");
        AREA_CODE.put("33", "\u6d59\u6c5f");
        AREA_CODE.put("34", "\u5b89\u5fbd");
        AREA_CODE.put("35", "\u798f\u5efa");
        AREA_CODE.put("36", "\u6c5f\u897f");
        AREA_CODE.put("37", "\u5c71\u4e1c");
        AREA_CODE.put("41", "\u6cb3\u5357");
        AREA_CODE.put("42", "\u6e56\u5317");
        AREA_CODE.put("43", "\u6e56\u5357");
        AREA_CODE.put("44", "\u5e7f\u4e1c");
        AREA_CODE.put("45", "\u5e7f\u897f");
        AREA_CODE.put("46", "\u6d77\u5357");
        AREA_CODE.put("50", "\u91cd\u5e86");
        AREA_CODE.put("51", "\u56db\u5ddd");
        AREA_CODE.put("52", "\u8d35\u5dde");
        AREA_CODE.put("53", "\u4e91\u5357");
        AREA_CODE.put("54", "\u897f\u85cf");
        AREA_CODE.put("61", "\u9655\u897f");
        AREA_CODE.put("62", "\u7518\u8083");
        AREA_CODE.put("63", "\u9752\u6d77");
        AREA_CODE.put("64", "\u5b81\u590f");
        AREA_CODE.put("65", "\u65b0\u7586");
        AREA_CODE.put("71", "\u53f0\u6e7e");
        AREA_CODE.put("81", "\u9999\u6e2f");
        AREA_CODE.put("82", "\u6fb3\u95e8");
        AREA_CODE.put("83", "\u53f0\u6e7e");
        AREA_CODE.put("91", "\u56fd\u5916");
        AREA_TW_CODE.put("A", 10);
        AREA_TW_CODE.put("B", 11);
        AREA_TW_CODE.put("C", 12);
        AREA_TW_CODE.put("D", 13);
        AREA_TW_CODE.put("E", 14);
        AREA_TW_CODE.put("F", 15);
        AREA_TW_CODE.put("G", 16);
        AREA_TW_CODE.put("H", 17);
        AREA_TW_CODE.put("J", 18);
        AREA_TW_CODE.put("K", 19);
        AREA_TW_CODE.put("L", 20);
        AREA_TW_CODE.put("M", 21);
        AREA_TW_CODE.put("N", 22);
        AREA_TW_CODE.put("P", 23);
        AREA_TW_CODE.put("Q", 24);
        AREA_TW_CODE.put("R", 25);
        AREA_TW_CODE.put("S", 26);
        AREA_TW_CODE.put("T", 27);
        AREA_TW_CODE.put("U", 28);
        AREA_TW_CODE.put("V", 29);
        AREA_TW_CODE.put("X", 30);
        AREA_TW_CODE.put("Y", 31);
        AREA_TW_CODE.put("W", 32);
        AREA_TW_CODE.put("Z", 33);
        AREA_TW_CODE.put("I", 34);
        AREA_TW_CODE.put("O", 35);
    }

    class CitizenInfo {
        private boolean verify;
        private String birthDate;
        private String province;
        private String cityCode;
        private Short birthYear;
        private Short birthMonth;
        private Short birthDay;
        private Integer age;
        private String gender;
        private String zodiac;
        private String animal;

        public boolean isVerify() {
            return this.verify;
        }

        public String getBirthDate() {
            return this.birthDate;
        }

        public String getProvince() {
            return this.province;
        }

        public String getCityCode() {
            return this.cityCode;
        }

        public Short getBirthYear() {
            return this.birthYear;
        }

        public Short getBirthMonth() {
            return this.birthMonth;
        }

        public Short getBirthDay() {
            return this.birthDay;
        }

        public Integer getAge() {
            return this.age;
        }

        public String getGender() {
            return this.gender;
        }

        public String getZodiac() {
            return this.zodiac;
        }

        public String getAnimal() {
            return this.animal;
        }

        public void setVerify(boolean verify) {
            this.verify = verify;
        }

        public void setBirthDate(String birthDate) {
            this.birthDate = birthDate;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public void setCityCode(String cityCode) {
            this.cityCode = cityCode;
        }

        public void setBirthYear(Short birthYear) {
            this.birthYear = birthYear;
        }

        public void setBirthMonth(Short birthMonth) {
            this.birthMonth = birthMonth;
        }

        public void setBirthDay(Short birthDay) {
            this.birthDay = birthDay;
        }

        public void setAge(Integer age) {
            this.age = age;
        }

        public void setGender(String gender) {
            this.gender = gender;
        }

        public void setZodiac(String zodiac) {
            this.zodiac = zodiac;
        }

        public void setAnimal(String animal) {
            this.animal = animal;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CitizenInfo)) {
                return false;
            }
            CitizenInfo other = (CitizenInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isVerify() != other.isVerify()) {
                return false;
            }
            Short this$birthYear = this.getBirthYear();
            Short other$birthYear = other.getBirthYear();
            if (this$birthYear == null ? other$birthYear != null : !((Object)this$birthYear).equals(other$birthYear)) {
                return false;
            }
            Short this$birthMonth = this.getBirthMonth();
            Short other$birthMonth = other.getBirthMonth();
            if (this$birthMonth == null ? other$birthMonth != null : !((Object)this$birthMonth).equals(other$birthMonth)) {
                return false;
            }
            Short this$birthDay = this.getBirthDay();
            Short other$birthDay = other.getBirthDay();
            if (this$birthDay == null ? other$birthDay != null : !((Object)this$birthDay).equals(other$birthDay)) {
                return false;
            }
            Integer this$age = this.getAge();
            Integer other$age = other.getAge();
            if (this$age == null ? other$age != null : !((Object)this$age).equals(other$age)) {
                return false;
            }
            String this$birthDate = this.getBirthDate();
            String other$birthDate = other.getBirthDate();
            if (this$birthDate == null ? other$birthDate != null : !this$birthDate.equals(other$birthDate)) {
                return false;
            }
            String this$province = this.getProvince();
            String other$province = other.getProvince();
            if (this$province == null ? other$province != null : !this$province.equals(other$province)) {
                return false;
            }
            String this$cityCode = this.getCityCode();
            String other$cityCode = other.getCityCode();
            if (this$cityCode == null ? other$cityCode != null : !this$cityCode.equals(other$cityCode)) {
                return false;
            }
            String this$gender = this.getGender();
            String other$gender = other.getGender();
            if (this$gender == null ? other$gender != null : !this$gender.equals(other$gender)) {
                return false;
            }
            String this$zodiac = this.getZodiac();
            String other$zodiac = other.getZodiac();
            if (this$zodiac == null ? other$zodiac != null : !this$zodiac.equals(other$zodiac)) {
                return false;
            }
            String this$animal = this.getAnimal();
            String other$animal = other.getAnimal();
            return !(this$animal == null ? other$animal != null : !this$animal.equals(other$animal));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CitizenInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isVerify() ? 79 : 97);
            Short $birthYear = this.getBirthYear();
            result = result * 59 + ($birthYear == null ? 43 : ((Object)$birthYear).hashCode());
            Short $birthMonth = this.getBirthMonth();
            result = result * 59 + ($birthMonth == null ? 43 : ((Object)$birthMonth).hashCode());
            Short $birthDay = this.getBirthDay();
            result = result * 59 + ($birthDay == null ? 43 : ((Object)$birthDay).hashCode());
            Integer $age = this.getAge();
            result = result * 59 + ($age == null ? 43 : ((Object)$age).hashCode());
            String $birthDate = this.getBirthDate();
            result = result * 59 + ($birthDate == null ? 43 : $birthDate.hashCode());
            String $province = this.getProvince();
            result = result * 59 + ($province == null ? 43 : $province.hashCode());
            String $cityCode = this.getCityCode();
            result = result * 59 + ($cityCode == null ? 43 : $cityCode.hashCode());
            String $gender = this.getGender();
            result = result * 59 + ($gender == null ? 43 : $gender.hashCode());
            String $zodiac = this.getZodiac();
            result = result * 59 + ($zodiac == null ? 43 : $zodiac.hashCode());
            String $animal = this.getAnimal();
            result = result * 59 + ($animal == null ? 43 : $animal.hashCode());
            return result;
        }

        public String toString() {
            return "CitizenIdKit.CitizenInfo(verify=" + this.isVerify() + ", birthDate=" + this.getBirthDate() + ", province=" + this.getProvince() + ", cityCode=" + this.getCityCode() + ", birthYear=" + this.getBirthYear() + ", birthMonth=" + this.getBirthMonth() + ", birthDay=" + this.getBirthDay() + ", age=" + this.getAge() + ", gender=" + this.getGender() + ", zodiac=" + this.getZodiac() + ", animal=" + this.getAnimal() + ")";
        }
    }
}

