/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.tree.TreeEntity;
import org.aoju.bus.core.lang.tree.TreeMap;
import org.aoju.bus.core.lang.tree.TreeNode;
import org.aoju.bus.core.lang.tree.parser.DefaultNodeParser;
import org.aoju.bus.core.lang.tree.parser.NodeParser;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;

public class TreeKit {
    public static List<TreeMap<Integer>> build(List<TreeNode<Integer>> list) {
        return TreeKit.build(list, 0);
    }

    public static <E> List<TreeMap<E>> build(List<TreeNode<E>> list, E parentId) {
        return TreeKit.build(list, parentId, TreeEntity.DEFAULT, new DefaultNodeParser());
    }

    public static <T, E> List<TreeMap<E>> build(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeKit.build(list, parentId, TreeEntity.DEFAULT, nodeParser);
    }

    public static <T, E> List<TreeMap<E>> build(List<T> list, E parentId, TreeEntity treeEntity, NodeParser<T, E> nodeParser) {
        ArrayList<TreeMap<T>> treeMapNodes = CollKit.newArrayList(new TreeMap[0]);
        for (T obj : list) {
            TreeMap treeMap = new TreeMap(treeEntity);
            nodeParser.parse(obj, treeMap);
            treeMapNodes.add(treeMap);
        }
        ArrayList<TreeMap<TreeMap>> finalTreeMapNodes = CollKit.newArrayList(new TreeMap[0]);
        for (TreeMap treeMap : treeMapNodes) {
            if (!parentId.equals(treeMap.getParentId())) continue;
            finalTreeMapNodes.add(treeMap);
            TreeKit.innerBuild(treeMapNodes, treeMap, 0, treeEntity.getDeep());
        }
        finalTreeMapNodes = finalTreeMapNodes.stream().sorted().collect(Collectors.toList());
        return finalTreeMapNodes;
    }

    private static <T> void innerBuild(List<TreeMap<T>> treeMapNodes, TreeMap<T> parentNode, int deep, Integer maxDeep) {
        if (CollKit.isEmpty(treeMapNodes)) {
            return;
        }
        if (maxDeep != null && deep >= maxDeep) {
            return;
        }
        treeMapNodes = treeMapNodes.stream().sorted().collect(Collectors.toList());
        for (TreeMap<T> childNode : treeMapNodes) {
            if (!parentNode.getId().equals(childNode.getParentId())) continue;
            List<TreeMap<T>> children = parentNode.getChildren();
            if (children == null) {
                children = CollKit.newArrayList(new TreeMap[0]);
                parentNode.setChildren(children);
            }
            children.add(childNode);
            childNode.setParent(parentNode);
            TreeKit.innerBuild(treeMapNodes, childNode, deep + 1, maxDeep);
        }
    }

    public static <T> TreeMap<T> getNode(TreeMap<T> node, T id) {
        if (ObjectKit.equal(id, node.getId())) {
            return node;
        }
        List<TreeMap<T>> children = node.getChildren();
        if (null == children) {
            return null;
        }
        for (TreeMap<T> child : children) {
            TreeMap<T> childNode = child.getNode(id);
            if (null == childNode) continue;
            return childNode;
        }
        return null;
    }

    public static <T> List<CharSequence> getParentsName(TreeMap<T> node, boolean includeCurrentNode) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        if (null == node) {
            return result;
        }
        if (includeCurrentNode) {
            result.add(node.getName());
        }
        for (TreeMap<T> parent = node.getParent(); null != parent; parent = parent.getParent()) {
            result.add(parent.getName());
        }
        return result;
    }
}

