/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron;

public enum Strategy {
    SERIAL_EXECUTION("Serial execution"),
    CONCURRENT_EXECUTION("Parallel flow"),
    DISCARD_LATER("Discard Later"),
    COVER_EARLY("Cover Early");

    private String title;

    private Strategy(String title) {
        this.title = title;
    }

    public static Strategy match(String name, Strategy defaultItem) {
        if (name != null) {
            for (Strategy item : Strategy.values()) {
                if (!item.name().equals(name)) continue;
                return item;
            }
        }
        return defaultItem;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

