/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie;

import java.util.List;
import java.util.Set;
import org.aoju.bus.core.collection.ConcurrentHashSet;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.goalie.Assets;
import org.aoju.bus.goalie.Registry;
import org.aoju.bus.logger.Logger;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;

public class Athlete {
    private final HttpServer httpServer;
    private final Set<Assets> assets = new ConcurrentHashSet<Assets>();
    private final List<Registry> assetRegistries;
    private DisposableServer disposableServer;

    public Athlete(HttpServer httpServer, List<Registry> assetRegistries) {
        this.httpServer = httpServer;
        this.assetRegistries = assetRegistries;
    }

    public Set<Assets> getAssets() {
        return this.assets;
    }

    public boolean addAssets(Assets assets) {
        return this.assets.add(assets);
    }

    public boolean amendAssets(Assets assets) {
        if (this.assets.contains(assets)) {
            this.assets.remove(assets);
            return this.assets.add(assets);
        }
        return false;
    }

    public boolean removeAssets(Assets assets) {
        return this.assets.remove(assets);
    }

    public void refreshAssets() {
        this.assets.clear();
        if (CollKit.isNotEmpty(this.assetRegistries)) {
            this.assetRegistries.forEach(registry -> {
                this.assets.addAll(registry.init());
                registry.setAthlete(this);
            });
        }
    }

    private void init() {
        this.refreshAssets();
        this.disposableServer = this.httpServer.bindNow();
        Logger.info("reactor server start on port:{} success", this.disposableServer.port());
    }

    private void destroy() {
        this.disposableServer.disposeNow();
        Logger.info("reactor server stop on port:{} success", this.disposableServer.port());
    }
}

