/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.handler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.goalie.Assets;
import org.aoju.bus.goalie.Context;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class ApiRouterHandler {
    private final Map<String, WebClient> clients = new ConcurrentHashMap<String, WebClient>();

    @NonNull
    public Mono<ServerResponse> handle(ServerRequest request) {
        Context context = Context.get(request);
        Assets assets = context.getAssets();
        Map<String, String> params = context.getRequestMap();
        String baseUrl = assets.getHost() + ':' + assets.getPort();
        WebClient webClient = this.clients.computeIfAbsent(baseUrl, client -> WebClient.create((String)baseUrl));
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)baseUrl).path(assets.getUrl());
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.setAll(params);
        if (HttpMethod.GET.equals((Object)assets.getHttpMethod())) {
            builder.queryParams((MultiValueMap)multiValueMap);
        }
        WebClient.RequestBodySpec bodySpec = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.method(assets.getHttpMethod()).uri(builder.build().encode().toUri())).headers(headers -> request.headers());
        if (!HttpMethod.GET.equals((Object)assets.getHttpMethod()) && request.headers().contentType().isPresent()) {
            MediaType mediaType = (MediaType)request.headers().contentType().get();
            if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(mediaType)) {
                LinkedMultiValueMap partMap = new LinkedMultiValueMap();
                partMap.setAll(context.getFilePartMap());
                BodyInserters.MultipartInserter multipartInserter = BodyInserters.fromMultipartData((MultiValueMap)partMap);
                params.forEach((arg_0, arg_1) -> ((BodyInserters.MultipartInserter)multipartInserter).with(arg_0, arg_1));
                bodySpec.body((BodyInserter)multipartInserter);
            } else {
                bodySpec.bodyValue((Object)multiValueMap);
            }
        }
        Flux flux = bodySpec.retrieve().bodyToFlux(DataBuffer.class);
        return ServerResponse.ok().body((Publisher)flux, DataBuffer.class);
    }
}

